/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.test.util;

import io.camunda.zeebe.test.util.record.RecordLogger;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BrokerClassRuleHelper
extends TestWatcher {
    public static final Logger LOG = LoggerFactory.getLogger((String)"io.camunda.zeebe.test");
    private String currentTestMethod;

    protected void failed(Throwable e, Description description) {
        RecordLogger.logRecords();
    }

    protected void starting(Description description) {
        this.currentTestMethod = description.getMethodName();
        RecordingExporter.reset();
    }

    public String getCurrentTestMethod() {
        return this.currentTestMethod;
    }

    public String getJobType() {
        return "job-" + this.currentTestMethod;
    }

    public String getBpmnProcessId() {
        return "process-" + this.currentTestMethod;
    }

    public String getCorrelationValue() {
        return "correlation-" + this.currentTestMethod;
    }

    public String getMessageName() {
        return "message-" + this.currentTestMethod;
    }
}

