/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.test.util;

import io.camunda.zeebe.util.buffer.BufferUtil;
import io.camunda.zeebe.util.buffer.BufferWriter;
import java.util.Arrays;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.assertj.core.api.AbstractAssert;

public final class BufferAssert
extends AbstractAssert<BufferAssert, DirectBuffer> {
    protected BufferAssert(DirectBuffer actual) {
        super((Object)actual, BufferAssert.class);
    }

    public static BufferAssert assertThatBuffer(DirectBuffer buffer) {
        return new BufferAssert(buffer);
    }

    public BufferAssert hasBytes(byte[] expected, int position) {
        this.isNotNull();
        byte[] actualBytes = new byte[expected.length];
        try {
            ((DirectBuffer)this.actual).getBytes(position, actualBytes, 0, actualBytes.length);
        }
        catch (Exception e) {
            this.failWithMessage("Unable to read %d bytes from actual: %s", new Object[]{actualBytes.length, e.getMessage()});
        }
        if (!Arrays.equals(expected, actualBytes)) {
            this.failWithMessage("Expected byte array match bytes <%s> but was <%s>", new Object[]{BufferUtil.bytesAsHexString((byte[])expected, (int)1), BufferUtil.bytesAsHexString((byte[])actualBytes, (int)1)});
        }
        return this;
    }

    public BufferAssert hasBytes(byte[] expected) {
        return this.hasBytes(expected, 0);
    }

    public BufferAssert hasBytes(DirectBuffer buffer, int offset, int length) {
        byte[] bytes = new byte[length];
        buffer.getBytes(offset, bytes);
        return this.hasBytes(bytes);
    }

    public BufferAssert hasBytes(DirectBuffer buffer) {
        return this.hasBytes(buffer, 0, buffer.capacity());
    }

    public BufferAssert hasCapacity(int expectedCapacity) {
        this.isNotNull();
        if (expectedCapacity != ((DirectBuffer)this.actual).capacity()) {
            this.failWithMessage("Expected capacity " + expectedCapacity + " but was " + ((DirectBuffer)this.actual).capacity(), new Object[0]);
        }
        return this;
    }

    public BufferAssert hasBytes(BufferWriter writer) {
        UnsafeBuffer buffer = new UnsafeBuffer(new byte[writer.getLength()]);
        writer.write((MutableDirectBuffer)buffer, 0);
        return this.hasBytes((DirectBuffer)buffer);
    }
}

