/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.test.util;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.camunda.zeebe.test.util.JsonUtil;
import io.camunda.zeebe.test.util.collection.MapBuilder;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Consumer;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.msgpack.core.MessageBufferPacker;
import org.msgpack.core.MessagePack;
import org.msgpack.jackson.dataformat.MessagePackFactory;

public final class MsgPackUtil {
    private static final ObjectMapper MSGPACK_MAPPER = new ObjectMapper((JsonFactory)new MessagePackFactory());

    public static DirectBuffer encodeMsgPack(CheckedConsumer<MessageBufferPacker> msgWriter) {
        MessageBufferPacker packer = MessagePack.newDefaultBufferPacker();
        try {
            msgWriter.accept(packer);
            packer.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        byte[] bytes = packer.toByteArray();
        return new UnsafeBuffer(bytes);
    }

    public static DirectBuffer asMsgPack(String key, Object value) {
        return MsgPackUtil.asMsgPack(Collections.singletonMap(key, value));
    }

    public static DirectBuffer asMsgPack(Consumer<MapBuilder<DirectBuffer>> consumer) {
        UnsafeBuffer buffer = new UnsafeBuffer(0L, 0);
        MapBuilder<UnsafeBuffer> builder = new MapBuilder<UnsafeBuffer>(buffer, arg_0 -> MsgPackUtil.lambda$asMsgPack$0((DirectBuffer)buffer, arg_0));
        consumer.accept(builder);
        return (DirectBuffer)builder.done();
    }

    public static DirectBuffer asMsgPack(Map<String, Object> map) {
        ObjectMapper objectMapper = new ObjectMapper((JsonFactory)new MessagePackFactory());
        try {
            byte[] msgPackBytes = objectMapper.writeValueAsBytes(map);
            return new UnsafeBuffer(msgPackBytes);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void assertEquality(byte[] actualMsgPack, String expectedJson) {
        Assert.assertNotNull((String)"actual msg pack is null", (Object)actualMsgPack);
        try {
            Assertions.assertThat((Iterable)MSGPACK_MAPPER.readTree(actualMsgPack)).isEqualTo((Object)JsonUtil.JSON_MAPPER.readTree(expectedJson));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void assertEquality(DirectBuffer actualMsgPack, String expectedJson) {
        Assert.assertNotNull((String)"actual msg pack is null", (Object)actualMsgPack);
        byte[] msgPackArray = new byte[actualMsgPack.capacity()];
        actualMsgPack.getBytes(0, msgPackArray);
        MsgPackUtil.assertEquality(msgPackArray, expectedJson);
    }

    public static void assertEqualityExcluding(DirectBuffer actualMsgPack, String expectedJson, String ... excludedProperties) {
        Assert.assertNotNull((String)"actual msg pack is null", (Object)actualMsgPack);
        byte[] msgPackArray = new byte[actualMsgPack.capacity()];
        actualMsgPack.getBytes(0, msgPackArray);
        MsgPackUtil.assertEqualityExcluding(msgPackArray, expectedJson, excludedProperties);
    }

    public static void assertEqualityExcluding(byte[] actualMsgPack, String expectedJson, String ... excludedProperties) {
        JsonNode jsonNode;
        JsonNode msgPackNode;
        Assert.assertNotNull((String)"actual msg pack is null", (Object)actualMsgPack);
        try {
            msgPackNode = MSGPACK_MAPPER.readTree(actualMsgPack);
            jsonNode = JsonUtil.JSON_MAPPER.readTree(expectedJson);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (!msgPackNode.isObject() || !jsonNode.isObject()) {
            throw new RuntimeException("both documents must be JSON objects");
        }
        ((ObjectNode)msgPackNode).remove(Arrays.asList(excludedProperties));
        ((ObjectNode)jsonNode).remove(Arrays.asList(excludedProperties));
        Assertions.assertThat((Iterable)msgPackNode).isEqualTo((Object)jsonNode);
    }

    public static byte[] asMsgPackReturnArray(String json) {
        try {
            return MSGPACK_MAPPER.writeValueAsBytes((Object)JsonUtil.JSON_MAPPER.readTree(json));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static DirectBuffer asMsgPack(String json) {
        return new UnsafeBuffer(MsgPackUtil.asMsgPackReturnArray(json));
    }

    private static /* synthetic */ void lambda$asMsgPack$0(DirectBuffer buffer, Map map) {
        buffer.wrap(MsgPackUtil.asMsgPack(map));
    }

    @FunctionalInterface
    public static interface CheckedConsumer<T> {
        public void accept(T var1) throws Exception;
    }
}

