/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.test.util;

import io.camunda.zeebe.util.Environment;
import io.camunda.zeebe.util.Loggers;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.slf4j.Logger;
import org.springframework.beans.factory.config.YamlPropertiesFactoryBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.bind.BindResult;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.context.properties.source.ConfigurationPropertySources;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;

public final class TestConfigurationFactory {
    public static final Logger LOG = Loggers.CONFIG_LOGGER;

    public <T> T create(InputStream configurationInputStream, Class<T> type) {
        ConfigurationProperties annotation = type.getAnnotation(ConfigurationProperties.class);
        if (annotation == null || annotation.prefix() == null) {
            throw new IllegalArgumentException("Unable to identify prefix for type" + type.getSimpleName());
        }
        String prefix = annotation.prefix();
        return this.create(null, prefix, configurationInputStream, type);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T create(Environment environment, String prefix, String fileName, Class<T> type) {
        LOG.debug("Reading configuration for {} from file {}", type, (Object)fileName);
        try (InputStream inputStream = new ClassPathResource(fileName).getInputStream();){
            T t = this.create(environment, prefix, inputStream, type);
            return t;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public <T> T create(Environment environment, String prefix, InputStream inputStream, Class<T> type) {
        T target;
        LOG.debug("Reading configuration for {} from input stream", type);
        Map<String, Object> propertiesFromEnvironment = this.convertEnvironmentIntoMap(environment);
        Properties propertiesFromFile = this.loadYamlProperties(inputStream);
        MutablePropertySources propertySources = new MutablePropertySources();
        propertySources.addLast((PropertySource)new MapPropertySource("environment properties strict", propertiesFromEnvironment));
        propertySources.addLast((PropertySource)new PropertiesPropertySource("properties from file", propertiesFromFile));
        try {
            Constructor<T> constructor = type.getConstructor(new Class[0]);
            target = constructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
        Iterable configPropertySource = ConfigurationPropertySources.from((Iterable)propertySources);
        BindResult bindResult = new Binder(configPropertySource).bind(prefix, type);
        if (!bindResult.isBound()) {
            LOG.warn("No binding result parsing the configuration. This is normal if the configuration is empty. Otherwise it is a configuration or programming error.");
            return target;
        }
        return (T)bindResult.get();
    }

    private Properties loadYamlProperties(InputStream inputStream) {
        InputStreamResource resource = new InputStreamResource(inputStream);
        YamlPropertiesFactoryBean factoryBean = new YamlPropertiesFactoryBean();
        factoryBean.setResources(new Resource[]{resource});
        return factoryBean.getObject();
    }

    private Map<String, Object> convertEnvironmentIntoMap(Environment environment) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (environment != null) {
            Set propertyKeys = environment.getPropertyKeys();
            for (String propertyKey : propertyKeys) {
                result.put(propertyKey, environment.get(propertyKey).orElse(null));
            }
        }
        return result;
    }
}

