/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.test.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TestEnvironment {
    private static final Logger LOG = LoggerFactory.getLogger((String)"io.camunda.zeebe.test.util");
    private static final String TEST_FORK_NUMBER_PROPERTY_NAME = "testForkNumber";
    private static final String TEST_MAVEN_ID_PROPERTY_NAME = "testMavenId";

    private TestEnvironment() {
    }

    public static int getTestForkNumber() {
        int testForkNumber = 0;
        try {
            String testForkNumberProperty = System.getProperty(TEST_FORK_NUMBER_PROPERTY_NAME);
            if (testForkNumberProperty != null) {
                testForkNumber = Integer.parseInt(testForkNumberProperty);
            } else {
                LOG.warn("No system property '{}' set, using default value {}", (Object)TEST_FORK_NUMBER_PROPERTY_NAME, (Object)testForkNumber);
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to read test fork number system property", (Throwable)e);
        }
        return testForkNumber;
    }

    public static int getTestMavenId() {
        int testMavenId = 0;
        try {
            String testMavenIdProperty = System.getProperty(TEST_MAVEN_ID_PROPERTY_NAME);
            if (testMavenIdProperty != null) {
                testMavenId = Integer.parseInt(testMavenIdProperty);
            } else {
                LOG.warn("No system property '{}' set, using default value {}", (Object)TEST_MAVEN_ID_PROPERTY_NAME, (Object)testMavenId);
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to read test maven id system property", (Throwable)e);
        }
        return testMavenId;
    }
}

