/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.test.util.asserts;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractPathAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.api.InstanceOfAssertFactory;

public final class DirectoryAssert
extends AbstractPathAssert<DirectoryAssert> {
    public DirectoryAssert(Path actual) {
        super(actual, DirectoryAssert.class);
    }

    public static DirectoryAssert assertThat(Path actual) {
        return new DirectoryAssert(actual);
    }

    public static InstanceOfAssertFactory<Path, DirectoryAssert> factory() {
        return new InstanceOfAssertFactory(Path.class, DirectoryAssert::assertThat);
    }

    public DirectoryAssert isDirectoryContainingExactly(Collection<? extends Path> collection) {
        this.paths.assertIsDirectory((AssertionInfo)this.info, (Path)this.actual);
        HashSet containedPaths = new HashSet();
        HashSet<? extends Path> expectedPaths = new HashSet<Path>(collection);
        try (Stream<Path> files = Files.list((Path)this.actual);){
            files.forEach(containedPaths::add);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        HashSet<? extends Path> missingPaths = new HashSet<Path>(expectedPaths);
        HashSet extraPaths = new HashSet(containedPaths);
        missingPaths.removeAll(containedPaths);
        extraPaths.removeAll(expectedPaths);
        if (!missingPaths.isEmpty() || !extraPaths.isEmpty()) {
            throw this.failure("%nPath %s should contain exactly the following %n%s%nBut found %n%s%nMissing paths: %n%s%nUnexpected paths: %n%s", new Object[]{this.actual, expectedPaths, containedPaths, missingPaths, extraPaths});
        }
        return (DirectoryAssert)this.myself;
    }

    public DirectoryAssert isDirectoryContainingExactly(Path ... paths) {
        return this.isDirectoryContainingExactly(Arrays.asList(paths));
    }

    public DirectoryAssert isDirectoryContainingAllOf(Collection<? extends Path> collection) {
        this.paths.assertIsDirectory((AssertionInfo)this.info, (Path)this.actual);
        HashSet containedPaths = new HashSet();
        HashSet<? extends Path> expectedPaths = new HashSet<Path>(collection);
        try (Stream<Path> files = Files.list((Path)this.actual);){
            files.forEach(containedPaths::add);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        HashSet<? extends Path> missingPaths = new HashSet<Path>(expectedPaths);
        missingPaths.removeAll(containedPaths);
        if (!missingPaths.isEmpty()) {
            throw this.failure("%nPath %s should contain exactly the following %n%s%nBut found %n%s%nMissing paths: %n%s", new Object[]{this.actual, expectedPaths, containedPaths, missingPaths});
        }
        return (DirectoryAssert)this.myself;
    }

    public DirectoryAssert isDirectoryContainingAllOf(Path ... paths) {
        return this.isDirectoryContainingAllOf(Arrays.asList(paths));
    }
}

