/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.test.util.asserts;

import io.camunda.zeebe.client.api.response.BrokerInfo;
import io.camunda.zeebe.client.api.response.PartitionInfo;
import io.camunda.zeebe.client.api.response.Topology;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.assertj.core.api.AbstractObjectAssert;

public final class TopologyAssert
extends AbstractObjectAssert<TopologyAssert, Topology> {
    public TopologyAssert(Topology topology) {
        super((Object)topology, TopologyAssert.class);
    }

    public static TopologyAssert assertThat(Topology actual) {
        return new TopologyAssert(actual);
    }

    public final TopologyAssert isComplete(int clusterSize, int partitionCount) {
        this.isNotNull();
        List brokers = ((Topology)this.actual).getBrokers();
        if (brokers.size() != clusterSize) {
            throw this.failure("Expected broker count to be <%s> but was <%s>", new Object[]{clusterSize, brokers.size()});
        }
        List brokersWithUnexpectedPartitionCount = brokers.stream().filter(b -> b.getPartitions().size() != partitionCount).collect(Collectors.toList());
        if (!brokersWithUnexpectedPartitionCount.isEmpty()) {
            throw this.failure("Expected <%s> partitions at each broker, but found brokers with different partition count <%s>", new Object[]{partitionCount, brokersWithUnexpectedPartitionCount});
        }
        Set partitions = brokers.stream().flatMap(b -> b.getPartitions().stream()).map(PartitionInfo::getPartitionId).collect(Collectors.toSet());
        Set partitionsWithLeader = brokers.stream().flatMap(b -> b.getPartitions().stream()).filter(PartitionInfo::isLeader).map(PartitionInfo::getPartitionId).collect(Collectors.toUnmodifiableSet());
        partitions.removeAll(partitionsWithLeader);
        if (!partitions.isEmpty()) {
            throw this.failure("Expected every partition to have a leader, but found the following have none: <%s>", new Object[]{partitions});
        }
        return (TopologyAssert)this.myself;
    }

    public final TopologyAssert doesNotContainBroker(int nodeId) {
        this.isNotNull();
        List brokers = ((Topology)this.actual).getBrokers().stream().map(BrokerInfo::getNodeId).collect(Collectors.toList());
        if (brokers.contains(nodeId)) {
            throw this.failure("Expected topology not to contain broker with ID %d, but found the following: [%s]", new Object[]{nodeId, brokers});
        }
        return (TopologyAssert)this.myself;
    }

    public final TopologyAssert hasBrokerSatisfying(Consumer<BrokerInfo> condition) {
        this.isNotNull();
        List brokers = ((Topology)this.actual).getBrokers();
        this.newListAssertInstance(brokers).anySatisfy(condition);
        return (TopologyAssert)this.myself;
    }

    public final TopologyAssert hasBrokersCount(int count) {
        this.isNotNull();
        if (((Topology)this.actual).getBrokers().size() != count) {
            throw this.failure("Expected topology to contain %d brokers, but it contains %s", new Object[]{count, ((Topology)this.actual).getBrokers()});
        }
        return (TopologyAssert)this.myself;
    }
}

