/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.test.util.bpmn.random;

import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.test.util.bpmn.random.IDGenerator;
import io.camunda.zeebe.test.util.bpmn.random.blocks.BlockSequenceBuilder;
import java.util.Random;
import java.util.function.Consumer;

public final class ConstructionContext {
    private static final Consumer<BpmnModelInstance> NOOP = x -> {};
    private final Random random;
    private final IDGenerator idGenerator;
    private final BlockSequenceBuilder.BlockSequenceBuilderFactory blockSequenceBuilderFactory;
    private final int maxBlocks;
    private final int maxDepth;
    private final int maxBranches;
    private final int currentDepth;
    private final Consumer<BpmnModelInstance> onAddCalledChildProcessCallback;

    private ConstructionContext(Random random, IDGenerator idGenerator, BlockSequenceBuilder.BlockSequenceBuilderFactory blockSequenceBuilderFactory, int maxBlocks, int maxDepth, int maxBranches, int currentDepth, Consumer<BpmnModelInstance> onAddCalledChildProcessCallback) {
        this.random = random;
        this.idGenerator = idGenerator;
        this.blockSequenceBuilderFactory = blockSequenceBuilderFactory;
        this.maxBlocks = maxBlocks;
        this.maxDepth = maxDepth;
        this.maxBranches = maxBranches;
        this.currentDepth = currentDepth;
        this.onAddCalledChildProcessCallback = onAddCalledChildProcessCallback;
    }

    ConstructionContext(Random random, IDGenerator idGenerator, BlockSequenceBuilder.BlockSequenceBuilderFactory factory, Integer maxBlocks, Integer maxDepth, Integer maxBranches, int currentDepth) {
        this(random, idGenerator, factory, maxBlocks, maxDepth, maxBranches, currentDepth, NOOP);
    }

    public void addCalledChildProcess(BpmnModelInstance childModelInstance) {
        this.onAddCalledChildProcessCallback.accept(childModelInstance);
    }

    public Random getRandom() {
        return this.random;
    }

    public IDGenerator getIdGenerator() {
        return this.idGenerator;
    }

    public BlockSequenceBuilder.BlockSequenceBuilderFactory getBlockSequenceBuilderFactory() {
        return this.blockSequenceBuilderFactory;
    }

    public int getMaxBlocks() {
        return this.maxBlocks;
    }

    public int getMaxDepth() {
        return this.maxDepth;
    }

    public int getMaxBranches() {
        return this.maxBranches;
    }

    public int getCurrentDepth() {
        return this.currentDepth;
    }

    public ConstructionContext withIncrementedDepth() {
        return new ConstructionContext(this.random, this.idGenerator, this.blockSequenceBuilderFactory, this.maxBlocks, this.maxDepth, this.maxBranches, this.currentDepth + 1, this.onAddCalledChildProcessCallback);
    }

    public ConstructionContext withAddCalledChildProcessCallback(Consumer<BpmnModelInstance> callback) {
        return new ConstructionContext(this.random, this.idGenerator, this.blockSequenceBuilderFactory, this.maxBlocks, this.maxDepth, this.maxBranches, this.currentDepth, callback);
    }
}

