/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.test.util.bpmn.random;

import io.camunda.zeebe.test.util.bpmn.random.ExecutionPathSegment;
import io.camunda.zeebe.test.util.bpmn.random.ScheduledExecutionStep;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public final class ExecutionPath {
    private final List<ScheduledExecutionStep> steps = new ArrayList<ScheduledExecutionStep>();
    private final String processId;

    public ExecutionPath(String processId, ExecutionPathSegment pathSegment) {
        this.processId = processId;
        this.steps.addAll(pathSegment.getScheduledSteps());
    }

    public String getProcessId() {
        return this.processId;
    }

    public List<ScheduledExecutionStep> getSteps() {
        return Collections.unmodifiableList(this.steps);
    }

    public int hashCode() {
        int result = this.steps.hashCode();
        result = 31 * result + this.processId.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExecutionPath that = (ExecutionPath)o;
        if (!this.steps.equals(that.steps)) {
            return false;
        }
        return this.processId.equals(that.processId);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

