/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.test.util.bpmn.random;

import io.camunda.zeebe.test.util.bpmn.random.ScheduledExecutionStep;
import io.camunda.zeebe.test.util.bpmn.random.steps.AbstractExecutionStep;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public final class ExecutionPathSegment {
    private final List<ScheduledExecutionStep> scheduledSteps = new ArrayList<ScheduledExecutionStep>();
    private final Map<String, Object> variableDefaults = new HashMap<String, Object>();

    public void appendDirectSuccessor(AbstractExecutionStep executionStep) {
        ScheduledExecutionStep predecessor = this.scheduledSteps.isEmpty() ? null : this.scheduledSteps.get(this.scheduledSteps.size() - 1);
        this.scheduledSteps.add(new ScheduledExecutionStep(predecessor, predecessor, executionStep));
    }

    public void appendExecutionSuccessor(AbstractExecutionStep executionStep, AbstractExecutionStep logicalPredecessorStep) {
        ScheduledExecutionStep executionPredecessor = this.scheduledSteps.isEmpty() ? null : this.scheduledSteps.get(this.scheduledSteps.size() - 1);
        ScheduledExecutionStep logicalPredecessor = this.scheduledSteps.stream().filter(scheduledStep -> scheduledStep.getStep() == logicalPredecessorStep).findFirst().orElseThrow(() -> new IllegalStateException("Unable to find step " + logicalPredecessorStep + ". This step was passed as a logical predecessor, thus it should already be present in the execution path segment. But it was not found."));
        this.scheduledSteps.add(new ScheduledExecutionStep(logicalPredecessor, executionPredecessor, executionStep));
    }

    public void append(ExecutionPathSegment pathToAdd) {
        this.mergeVariableDefaults(pathToAdd);
        pathToAdd.getScheduledSteps().forEach(this::append);
    }

    public void append(ScheduledExecutionStep scheduledExecutionStep) {
        ScheduledExecutionStep logicalPredecessor = scheduledExecutionStep.getLogicalPredecessor();
        if (logicalPredecessor == null) {
            this.appendDirectSuccessor(scheduledExecutionStep.getStep());
        } else {
            this.appendExecutionSuccessor(scheduledExecutionStep.getStep(), logicalPredecessor.getStep());
        }
    }

    public boolean canBeInterrupted() {
        return this.scheduledSteps.stream().map(ScheduledExecutionStep::getStep).anyMatch(Predicate.not(AbstractExecutionStep::isAutomatic));
    }

    public void setVariableDefault(String key, Object value) {
        this.variableDefaults.put(key, value);
    }

    public void mergeVariableDefaults(ExecutionPathSegment other) {
        this.variableDefaults.putAll(other.variableDefaults);
    }

    public void cutAtRandomPosition(Random random) {
        if (!this.canBeInterrupted()) {
            throw new IllegalArgumentException("This execution flow cannot be interrupted");
        }
        this.scheduledSteps.subList(this.findCutOffPoint(random), this.scheduledSteps.size()).clear();
    }

    private ExecutionBoundaries findExecutionBoundaries() {
        ExecutionBoundaries cutOffPoints = new ExecutionBoundaries();
        for (int index = 0; index < this.scheduledSteps.size(); ++index) {
            AbstractExecutionStep step = this.scheduledSteps.get(index).getStep();
            if (step.isAutomatic()) continue;
            cutOffPoints.addBoundary(index);
        }
        return cutOffPoints;
    }

    private int findCutOffPoint(Random random) {
        ExecutionBoundaries executionBoundaries = this.findExecutionBoundaries();
        return executionBoundaries.chooseRandomBoundary(random);
    }

    public void insertExecutionStep(Random random, AbstractExecutionStep executionStep) {
        ScheduledExecutionStep newStep;
        if (executionStep.getDeltaTime().toMillis() > AbstractExecutionStep.VIRTUALLY_NO_TIME.toMillis()) {
            throw new RuntimeException("Not yet implemented. This insert logic only works if the step that is inserted takes almost no time.");
        }
        int index = this.findCutOffPoint(random);
        ScheduledExecutionStep successor = this.scheduledSteps.remove(index);
        if (index == 0) {
            newStep = new ScheduledExecutionStep(null, null, executionStep);
        } else {
            ScheduledExecutionStep predecessor = this.scheduledSteps.get(index - 1);
            newStep = new ScheduledExecutionStep(predecessor, predecessor, executionStep);
        }
        this.scheduledSteps.add(index, new ScheduledExecutionStep(successor.getLogicalPredecessor(), newStep, successor.getStep()));
        this.scheduledSteps.add(index, newStep);
    }

    public List<ScheduledExecutionStep> getScheduledSteps() {
        return Collections.unmodifiableList(this.scheduledSteps);
    }

    public List<AbstractExecutionStep> getSteps() {
        return this.scheduledSteps.stream().map(ScheduledExecutionStep::getStep).collect(Collectors.toList());
    }

    public Map<String, Object> collectVariables() {
        HashMap<String, Object> result = new HashMap<String, Object>(this.variableDefaults);
        this.scheduledSteps.forEach(scheduledStep -> result.putAll(scheduledStep.getVariables()));
        return result;
    }

    public int hashCode() {
        return this.scheduledSteps.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExecutionPathSegment that = (ExecutionPathSegment)o;
        return this.scheduledSteps.equals(that.scheduledSteps);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    private static final class ExecutionBoundaries {
        private final List<Integer> boundaries = new ArrayList<Integer>();

        private ExecutionBoundaries() {
        }

        void addBoundary(int boundaryIndex) {
            this.boundaries.add(boundaryIndex);
        }

        public int chooseRandomBoundary(Random random) {
            return this.boundaries.isEmpty() ? 0 : this.boundaries.get(random.nextInt(this.boundaries.size()));
        }
    }
}

