/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.test.util.bpmn.random;

import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.model.bpmn.instance.BaseElement;
import io.camunda.zeebe.model.bpmn.instance.Process;
import io.camunda.zeebe.test.util.bpmn.random.ConstructionContext;
import io.camunda.zeebe.test.util.bpmn.random.ExecutionPath;
import io.camunda.zeebe.test.util.bpmn.random.IDGenerator;
import io.camunda.zeebe.test.util.bpmn.random.blocks.BlockSequenceBuilder;
import io.camunda.zeebe.test.util.bpmn.random.blocks.ProcessBuilder;
import io.camunda.zeebe.util.collection.Tuple;
import java.io.File;
import java.util.List;
import java.util.Optional;
import java.util.Random;

public final class RandomProcessGenerator {
    public static final int MAX_BLOCKS = 5;
    public static final int MAX_DEPTH = 3;
    public static final int MAX_BRANCHES = 3;
    public static final double PROBABILITY_BOUNDARY_TIMER_EVENT = 0.2;
    public static final double PROBABILITY_BOUNDARY_ERROR_EVENT = 0.2;
    private static final BlockSequenceBuilder.BlockSequenceBuilderFactory FACTORY = new BlockSequenceBuilder.BlockSequenceBuilderFactory();
    private final ProcessBuilder processBuilder;

    public RandomProcessGenerator(long seed, Integer maxBlocks, Integer maxDepth, Integer maxBranches) {
        Random random = new Random(seed);
        IDGenerator idGenerator = new IDGenerator(0L);
        ConstructionContext context = new ConstructionContext(random, idGenerator, FACTORY, Optional.ofNullable(maxBlocks).orElse(5), Optional.ofNullable(maxDepth).orElse(3), Optional.ofNullable(maxBranches).orElse(3), 0);
        this.processBuilder = new ProcessBuilder(context);
    }

    public List<BpmnModelInstance> buildProcesses() {
        return this.processBuilder.buildProcess();
    }

    public ExecutionPath findRandomExecutionPath(long seed) {
        return this.processBuilder.findRandomExecutionPath(new Random(seed));
    }

    public static void main(String[] args) {
        Random random = new Random();
        for (int i = 0; i < 10; ++i) {
            int index = i;
            System.out.println("Generating process " + index);
            RandomProcessGenerator builder = new RandomProcessGenerator(random.nextLong(), 5, 3, 3);
            List<BpmnModelInstance> bpmnModelInstances = builder.buildProcesses();
            bpmnModelInstances.stream().map(modelInstance -> new Tuple((Object)RandomProcessGenerator.createFile(modelInstance, index), modelInstance)).forEach(tuple -> Bpmn.writeModelToFile((File)((File)tuple.getLeft()), (BpmnModelInstance)((BpmnModelInstance)tuple.getRight())));
            for (int p = 0; p < 5; ++p) {
                ExecutionPath path = builder.findRandomExecutionPath(random.nextLong());
                System.out.println("Execution path " + p + " :" + path);
            }
        }
    }

    private static File createFile(BpmnModelInstance bpmnModelInstance, int index) {
        return bpmnModelInstance.getDefinitions().getChildElementsByType(Process.class).stream().map(BaseElement::getId).map(id -> index + "-" + id + ".bpmn").map(File::new).findFirst().orElseThrow();
    }
}

