/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.test.util.bpmn.random;

import io.camunda.zeebe.test.util.bpmn.random.steps.AbstractExecutionStep;
import java.time.Duration;
import java.util.Map;

public class ScheduledExecutionStep {
    private final AbstractExecutionStep step;
    private final ScheduledExecutionStep logicalPredecessor;
    private final Duration activationTime;
    private final Duration startTime;
    private final Duration endTime;
    private final Duration activationDuration;

    protected ScheduledExecutionStep(ScheduledExecutionStep logicalPredecessor, ScheduledExecutionStep executionPredecessor, AbstractExecutionStep step) {
        this.logicalPredecessor = logicalPredecessor;
        this.step = step;
        this.startTime = executionPredecessor != null ? executionPredecessor.getEndTime() : Duration.ofMillis(0L);
        this.activationTime = logicalPredecessor != null ? logicalPredecessor.getEndTime() : this.startTime;
        this.endTime = this.startTime.plus(step.getDeltaTime());
        this.activationDuration = this.endTime.minus(this.activationTime);
    }

    public Map<String, Object> getVariables() {
        return this.step.getVariables(this.getActivationDuration());
    }

    public AbstractExecutionStep getStep() {
        return this.step;
    }

    public ScheduledExecutionStep getLogicalPredecessor() {
        return this.logicalPredecessor;
    }

    public final Duration getActivationTime() {
        return this.activationTime;
    }

    public final Duration getStartTime() {
        return this.startTime;
    }

    public final Duration getEndTime() {
        return this.endTime;
    }

    public final Duration getActivationDuration() {
        return this.activationDuration;
    }

    public int hashCode() {
        return this.step.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScheduledExecutionStep that = (ScheduledExecutionStep)o;
        if (!this.step.equals(that.step)) {
            return false;
        }
        if (!this.activationTime.equals(that.activationTime)) {
            return false;
        }
        if (!this.startTime.equals(that.startTime)) {
            return false;
        }
        if (!this.endTime.equals(that.endTime)) {
            return false;
        }
        return this.activationDuration.equals(that.activationDuration);
    }

    public String toString() {
        return "ScheduledExecutionStep{step=" + this.step + ", activationTime=" + this.activationTime + ", startTime=" + this.startTime + ", endTime=" + this.endTime + ", activationDuration=" + this.activationDuration + "}";
    }
}

