/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.test.util.bpmn.random;

import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.test.util.bpmn.random.ExecutionPath;
import io.camunda.zeebe.test.util.bpmn.random.RandomProcessGenerator;
import io.camunda.zeebe.test.util.bpmn.random.ScheduledExecutionStep;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Random;

public class TestDataGenerator {
    static final Random RANDOM = new Random();

    public static Collection<TestDataRecord> generateTestRecords(int processes, int pathsPerProcess) {
        ArrayList<TestDataRecord> records = new ArrayList<TestDataRecord>();
        for (int processIndex = 0; processIndex < processes; ++processIndex) {
            long processSeed = RANDOM.nextLong();
            RandomProcessGenerator generator = new RandomProcessGenerator(processSeed, null, null, null);
            List<BpmnModelInstance> bpmnModelInstances = generator.buildProcesses();
            HashSet<ExecutionPath> paths = new HashSet<ExecutionPath>();
            for (int pathIndex = 0; pathIndex < pathsPerProcess; ++pathIndex) {
                long pathSeed = RANDOM.nextLong();
                ExecutionPath path = generator.findRandomExecutionPath(pathSeed);
                boolean isDifferentPath = paths.add(path);
                if (!isDifferentPath) continue;
                records.add(new TestDataRecord(processSeed, pathSeed, bpmnModelInstances, path));
            }
        }
        return records;
    }

    public static TestDataRecord regenerateTestRecord(long processSeed, long executionPathSeed) {
        RandomProcessGenerator generator = new RandomProcessGenerator(processSeed, null, null, null);
        List<BpmnModelInstance> bpmnModelInstances = generator.buildProcesses();
        ExecutionPath path = generator.findRandomExecutionPath(executionPathSeed);
        return new TestDataRecord(processSeed, executionPathSeed, bpmnModelInstances, path);
    }

    public static final class TestDataRecord {
        private final long processSeed;
        private final long executionPathSeed;
        private final List<BpmnModelInstance> bpmnModels;
        private final ExecutionPath executionPath;
        private ScheduledExecutionStep currentStep;

        private TestDataRecord(long processSeed, long executionPathSeed, List<BpmnModelInstance> bpmnModels, ExecutionPath executionPath) {
            this.processSeed = processSeed;
            this.executionPathSeed = executionPathSeed;
            this.bpmnModels = bpmnModels;
            this.executionPath = executionPath;
        }

        public List<BpmnModelInstance> getBpmnModels() {
            return this.bpmnModels;
        }

        public ExecutionPath getExecutionPath() {
            return this.executionPath;
        }

        public ScheduledExecutionStep getCurrentStep() {
            return this.currentStep;
        }

        public void setCurrentStep(ScheduledExecutionStep currentStep) {
            this.currentStep = currentStep;
        }

        public String toString() {
            return "TestDataRecord{processSeed=" + this.processSeed + ", executionPathSeed=" + this.executionPathSeed + "}";
        }
    }
}

