/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.test.util.bpmn.random.blocks;

import io.camunda.zeebe.model.bpmn.builder.AbstractFlowNodeBuilder;
import io.camunda.zeebe.test.util.bpmn.random.BlockBuilder;
import io.camunda.zeebe.test.util.bpmn.random.BlockBuilderFactory;
import io.camunda.zeebe.test.util.bpmn.random.ConstructionContext;
import io.camunda.zeebe.test.util.bpmn.random.ExecutionPathSegment;
import io.camunda.zeebe.test.util.bpmn.random.blocks.CallActivityBlockBuilder;
import io.camunda.zeebe.test.util.bpmn.random.blocks.EventBasedGatewayBlockBuilder;
import io.camunda.zeebe.test.util.bpmn.random.blocks.ExclusiveGatewayBlockBuilder;
import io.camunda.zeebe.test.util.bpmn.random.blocks.IntermediateMessageCatchEventBlockBuilder;
import io.camunda.zeebe.test.util.bpmn.random.blocks.JobWorkerTaskBlockBuilder;
import io.camunda.zeebe.test.util.bpmn.random.blocks.ParallelGatewayBlockBuilder;
import io.camunda.zeebe.test.util.bpmn.random.blocks.ReceiveTaskBlockBuilder;
import io.camunda.zeebe.test.util.bpmn.random.blocks.SubProcessBlockBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;

public class BlockSequenceBuilder
implements BlockBuilder {
    private static final List<BlockBuilderFactory> BLOCK_BUILDER_FACTORIES = Arrays.asList(JobWorkerTaskBlockBuilder.serviceTaskFactory(), JobWorkerTaskBlockBuilder.businessRuleTaskFactory(), JobWorkerTaskBlockBuilder.scriptTaskFactory(), JobWorkerTaskBlockBuilder.sendTaskFactory(), new IntermediateMessageCatchEventBlockBuilder.Factory(), new SubProcessBlockBuilder.Factory(), new ExclusiveGatewayBlockBuilder.Factory(), new ParallelGatewayBlockBuilder.Factory(), new ReceiveTaskBlockBuilder.Factory(), new EventBasedGatewayBlockBuilder.Factory(), new ReceiveTaskBlockBuilder.Factory(), new CallActivityBlockBuilder.Factory());
    private final List<BlockBuilder> blockBuilders = new ArrayList<BlockBuilder>();

    public BlockSequenceBuilder(ConstructionContext context) {
        Random random = context.getRandom();
        int maxDepth = context.getMaxDepth();
        int maxBlocks = context.getMaxBlocks();
        int currentDepth = context.getCurrentDepth();
        if (currentDepth < maxDepth) {
            int steps = random.nextInt(Math.max(0, maxBlocks - currentDepth));
            for (int step = 0; step < steps; ++step) {
                BlockBuilderFactory blockBuilderFactory;
                do {
                    blockBuilderFactory = BLOCK_BUILDER_FACTORIES.get(random.nextInt(BLOCK_BUILDER_FACTORIES.size()));
                } while (currentDepth == maxDepth - 1 && blockBuilderFactory.isAddingDepth());
                this.blockBuilders.add(blockBuilderFactory.createBlockBuilder(context));
            }
        }
    }

    @Override
    public AbstractFlowNodeBuilder<?, ?> buildFlowNodes(AbstractFlowNodeBuilder<?, ?> nodeBuilder) {
        AbstractFlowNodeBuilder<?, ?> processWorkInProgress = nodeBuilder;
        for (BlockBuilder builder : this.blockBuilders) {
            processWorkInProgress = builder.buildFlowNodes(processWorkInProgress);
        }
        return processWorkInProgress;
    }

    @Override
    public ExecutionPathSegment findRandomExecutionPath(Random random) {
        ExecutionPathSegment result = new ExecutionPathSegment();
        this.blockBuilders.forEach(blockBuilder -> result.append(blockBuilder.findRandomExecutionPath(random)));
        return result;
    }

    public static class BlockSequenceBuilderFactory {
        public BlockSequenceBuilder createBlockSequenceBuilder(ConstructionContext context) {
            return new BlockSequenceBuilder(context);
        }
    }
}

