/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.test.util.bpmn.random.blocks;

import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.model.bpmn.builder.AbstractFlowNodeBuilder;
import io.camunda.zeebe.model.bpmn.builder.CallActivityBuilder;
import io.camunda.zeebe.test.util.bpmn.random.BlockBuilder;
import io.camunda.zeebe.test.util.bpmn.random.BlockBuilderFactory;
import io.camunda.zeebe.test.util.bpmn.random.ConstructionContext;
import io.camunda.zeebe.test.util.bpmn.random.ExecutionPathSegment;
import io.camunda.zeebe.test.util.bpmn.random.IDGenerator;
import io.camunda.zeebe.test.util.bpmn.random.blocks.BlockSequenceBuilder;
import java.util.Random;

public class CallActivityBlockBuilder
implements BlockBuilder {
    private final boolean shouldPropagateAllChildVariables;
    private final String calledProcessId;
    private final BlockSequenceBuilder calledProcessBuilder;
    private final ConstructionContext context;
    private final String callActivityId;

    public CallActivityBlockBuilder(ConstructionContext context) {
        Random random = context.getRandom();
        IDGenerator idGenerator = context.getIdGenerator();
        int maxDepth = context.getMaxDepth();
        int currentDepth = context.getCurrentDepth();
        boolean goDeeper = random.nextInt(maxDepth) > currentDepth;
        this.context = context;
        this.shouldPropagateAllChildVariables = random.nextBoolean();
        String reusableId = idGenerator.nextId();
        this.calledProcessId = "process_child_" + reusableId;
        this.callActivityId = "call_activity_" + reusableId;
        this.calledProcessBuilder = goDeeper ? context.getBlockSequenceBuilderFactory().createBlockSequenceBuilder(context.withIncrementedDepth()) : null;
    }

    @Override
    public AbstractFlowNodeBuilder<?, ?> buildFlowNodes(AbstractFlowNodeBuilder<?, ?> nodeBuilder) {
        this.buildChildProcess();
        return ((CallActivityBuilder)nodeBuilder.callActivity(this.callActivityId).zeebeProcessId(this.calledProcessId)).zeebePropagateAllChildVariables(this.shouldPropagateAllChildVariables);
    }

    @Override
    public ExecutionPathSegment findRandomExecutionPath(Random random) {
        ExecutionPathSegment result = new ExecutionPathSegment();
        if (this.calledProcessBuilder != null) {
            result.append(this.calledProcessBuilder.findRandomExecutionPath(random));
        }
        return result;
    }

    private void buildChildProcess() {
        AbstractFlowNodeBuilder<?, ?> workInProgress = Bpmn.createExecutableProcess((String)this.calledProcessId).startEvent();
        if (this.calledProcessBuilder != null) {
            workInProgress = this.calledProcessBuilder.buildFlowNodes(workInProgress);
        }
        BpmnModelInstance childModelInstance = workInProgress.endEvent().done();
        this.context.addCalledChildProcess(childModelInstance);
    }

    public static class Factory
    implements BlockBuilderFactory {
        @Override
        public BlockBuilder createBlockBuilder(ConstructionContext context) {
            return new CallActivityBlockBuilder(context);
        }

        @Override
        public boolean isAddingDepth() {
            return true;
        }
    }
}

