/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.test.util.bpmn.random.blocks;

import io.camunda.zeebe.model.bpmn.builder.AbstractFlowNodeBuilder;
import io.camunda.zeebe.model.bpmn.builder.EventBasedGatewayBuilder;
import io.camunda.zeebe.model.bpmn.builder.ExclusiveGatewayBuilder;
import io.camunda.zeebe.model.bpmn.builder.IntermediateCatchEventBuilder;
import io.camunda.zeebe.test.util.bpmn.random.BlockBuilder;
import io.camunda.zeebe.test.util.bpmn.random.BlockBuilderFactory;
import io.camunda.zeebe.test.util.bpmn.random.ConstructionContext;
import io.camunda.zeebe.test.util.bpmn.random.ExecutionPathSegment;
import io.camunda.zeebe.test.util.bpmn.random.IDGenerator;
import io.camunda.zeebe.test.util.bpmn.random.blocks.BlockSequenceBuilder;
import io.camunda.zeebe.test.util.bpmn.random.steps.StepPublishMessage;
import io.camunda.zeebe.util.collection.Tuple;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class EventBasedGatewayBlockBuilder
implements BlockBuilder {
    private static final String CORRELATION_KEY_FIELD = "correlationKey";
    private static final String CORRELATION_KEY_VALUE = "default_correlation_key";
    private static final String MESSAGE_NAME_PREFIX = "message_";
    private final String forkGatewayId;
    private final String joinGatewayId;
    private final List<Tuple<String, BlockBuilder>> branches = new ArrayList<Tuple<String, BlockBuilder>>();

    public EventBasedGatewayBlockBuilder(ConstructionContext context) {
        Random random = context.getRandom();
        IDGenerator idGenerator = context.getIdGenerator();
        int maxBranches = context.getMaxBranches();
        this.forkGatewayId = "fork_" + idGenerator.nextId();
        this.joinGatewayId = "join_" + idGenerator.nextId();
        BlockSequenceBuilder.BlockSequenceBuilderFactory blockSequenceBuilderFactory = context.getBlockSequenceBuilderFactory();
        int numberOfBranches = Math.max(2, random.nextInt(maxBranches));
        for (int i = 0; i < numberOfBranches; ++i) {
            String branchId = idGenerator.nextId();
            BlockSequenceBuilder branchBuilder = blockSequenceBuilderFactory.createBlockSequenceBuilder(context.withIncrementedDepth());
            this.branches.add((Tuple<String, BlockBuilder>)new Tuple((Object)branchId, (Object)branchBuilder));
        }
    }

    @Override
    public AbstractFlowNodeBuilder<?, ?> buildFlowNodes(AbstractFlowNodeBuilder<?, ?> nodeBuilder) {
        EventBasedGatewayBuilder forkGateway = nodeBuilder.eventBasedGateway(this.forkGatewayId);
        AbstractFlowNodeBuilder<?, ?> firstBranch = this.addBranch(forkGateway, this.branches.get(0));
        ExclusiveGatewayBuilder joinGateway = firstBranch.exclusiveGateway(this.joinGatewayId);
        this.branches.stream().skip(1L).forEach(branch -> this.addBranch(forkGateway, (Tuple<String, BlockBuilder>)branch).connectTo(this.joinGatewayId));
        return joinGateway;
    }

    @Override
    public ExecutionPathSegment findRandomExecutionPath(Random random) {
        ExecutionPathSegment result = new ExecutionPathSegment();
        int branchNumber = random.nextInt(this.branches.size());
        Tuple<String, BlockBuilder> branch = this.branches.get(branchNumber);
        BlockBuilder blockBuilder = (BlockBuilder)branch.getRight();
        StepPublishMessage executionStep = new StepPublishMessage(this.getMessageName(branch), CORRELATION_KEY_FIELD, CORRELATION_KEY_VALUE);
        result.appendDirectSuccessor(executionStep);
        result.append(blockBuilder.findRandomExecutionPath(random));
        return result;
    }

    private AbstractFlowNodeBuilder<?, ?> addBranch(EventBasedGatewayBuilder gatewayBuilder, Tuple<String, BlockBuilder> branch) {
        String branchId = (String)branch.getLeft();
        BlockBuilder branchBlockBuilder = (BlockBuilder)branch.getRight();
        IntermediateCatchEventBuilder catchEvent = gatewayBuilder.intermediateCatchEvent(branchId);
        catchEvent.message(messageBuilder -> {
            messageBuilder.zeebeCorrelationKeyExpression(CORRELATION_KEY_FIELD);
            messageBuilder.name(this.getMessageName(branch));
        });
        return branchBlockBuilder.buildFlowNodes((AbstractFlowNodeBuilder<?, ?>)catchEvent);
    }

    private String getMessageName(Tuple<String, BlockBuilder> branch) {
        String branchId = (String)branch.getLeft();
        return MESSAGE_NAME_PREFIX + branchId;
    }

    static class Factory
    implements BlockBuilderFactory {
        Factory() {
        }

        @Override
        public BlockBuilder createBlockBuilder(ConstructionContext context) {
            return new EventBasedGatewayBlockBuilder(context);
        }

        @Override
        public boolean isAddingDepth() {
            return true;
        }
    }
}

