/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.test.util.bpmn.random.blocks;

import io.camunda.zeebe.model.bpmn.builder.AbstractFlowNodeBuilder;
import io.camunda.zeebe.model.bpmn.builder.ExclusiveGatewayBuilder;
import io.camunda.zeebe.test.util.bpmn.random.BlockBuilder;
import io.camunda.zeebe.test.util.bpmn.random.BlockBuilderFactory;
import io.camunda.zeebe.test.util.bpmn.random.ConstructionContext;
import io.camunda.zeebe.test.util.bpmn.random.ExecutionPathSegment;
import io.camunda.zeebe.test.util.bpmn.random.IDGenerator;
import io.camunda.zeebe.test.util.bpmn.random.blocks.BlockSequenceBuilder;
import io.camunda.zeebe.test.util.bpmn.random.steps.StepPickConditionCase;
import io.camunda.zeebe.test.util.bpmn.random.steps.StepPickDefaultCase;
import io.camunda.zeebe.test.util.bpmn.random.steps.StepRaiseIncidentThenResolveAndPickConditionCase;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class ExclusiveGatewayBlockBuilder
implements BlockBuilder {
    private final List<BlockBuilder> blockBuilders = new ArrayList<BlockBuilder>();
    private final List<String> branchIds = new ArrayList<String>();
    private final String forkGatewayId;
    private final String joinGatewayId;
    private final String gatewayConditionVariable;

    public ExclusiveGatewayBlockBuilder(ConstructionContext context) {
        Random random = context.getRandom();
        IDGenerator idGenerator = context.getIdGenerator();
        int maxBranches = context.getMaxBranches();
        this.forkGatewayId = "fork_" + idGenerator.nextId();
        this.joinGatewayId = "join_" + idGenerator.nextId();
        this.gatewayConditionVariable = this.forkGatewayId + "_branch";
        BlockSequenceBuilder.BlockSequenceBuilderFactory blockSequenceBuilderFactory = context.getBlockSequenceBuilderFactory();
        int branches = Math.max(2, random.nextInt(maxBranches));
        for (int i = 0; i < branches; ++i) {
            this.branchIds.add("edge_" + idGenerator.nextId());
            this.blockBuilders.add(blockSequenceBuilderFactory.createBlockSequenceBuilder(context.withIncrementedDepth()));
        }
    }

    @Override
    public AbstractFlowNodeBuilder<?, ?> buildFlowNodes(AbstractFlowNodeBuilder<?, ?> nodeBuilder) {
        ExclusiveGatewayBuilder forkGateway = nodeBuilder.exclusiveGateway(this.forkGatewayId);
        ExclusiveGatewayBuilder workInProgress = this.blockBuilders.get(0).buildFlowNodes((AbstractFlowNodeBuilder<?, ?>)forkGateway.defaultFlow()).exclusiveGateway(this.joinGatewayId);
        for (int i = 1; i < this.blockBuilders.size(); ++i) {
            String edgeId = this.branchIds.get(i);
            BlockBuilder blockBuilder = this.blockBuilders.get(i);
            AbstractFlowNodeBuilder outgoingEdge = workInProgress.moveToNode(this.forkGatewayId).sequenceFlowId(edgeId).conditionExpression(this.gatewayConditionVariable + " = \"" + edgeId + "\"");
            workInProgress = blockBuilder.buildFlowNodes(outgoingEdge).connectTo(this.joinGatewayId);
        }
        return workInProgress;
    }

    @Override
    public ExecutionPathSegment findRandomExecutionPath(Random random) {
        ExecutionPathSegment result = new ExecutionPathSegment();
        int branch = random.nextInt(this.branchIds.size());
        if (branch == 0) {
            result.appendDirectSuccessor(new StepPickDefaultCase(this.forkGatewayId, this.gatewayConditionVariable));
        } else if (random.nextBoolean()) {
            result.appendDirectSuccessor(new StepPickConditionCase(this.forkGatewayId, this.gatewayConditionVariable, this.branchIds.get(branch)));
        } else {
            result.appendDirectSuccessor(new StepRaiseIncidentThenResolveAndPickConditionCase(this.forkGatewayId, this.gatewayConditionVariable, this.branchIds.get(branch)));
        }
        BlockBuilder blockBuilder = this.blockBuilders.get(branch);
        result.append(blockBuilder.findRandomExecutionPath(random));
        return result;
    }

    static class Factory
    implements BlockBuilderFactory {
        Factory() {
        }

        @Override
        public BlockBuilder createBlockBuilder(ConstructionContext context) {
            return new ExclusiveGatewayBlockBuilder(context);
        }

        @Override
        public boolean isAddingDepth() {
            return true;
        }
    }
}

