/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.test.util.bpmn.random.blocks;

import io.camunda.zeebe.model.bpmn.builder.AbstractFlowNodeBuilder;
import io.camunda.zeebe.model.bpmn.builder.AbstractJobWorkerTaskBuilder;
import io.camunda.zeebe.model.bpmn.builder.ExclusiveGatewayBuilder;
import io.camunda.zeebe.test.util.bpmn.random.BlockBuilder;
import io.camunda.zeebe.test.util.bpmn.random.BlockBuilderFactory;
import io.camunda.zeebe.test.util.bpmn.random.ConstructionContext;
import io.camunda.zeebe.test.util.bpmn.random.ExecutionPathSegment;
import io.camunda.zeebe.test.util.bpmn.random.IDGenerator;
import io.camunda.zeebe.test.util.bpmn.random.steps.AbstractExecutionStep;
import io.camunda.zeebe.test.util.bpmn.random.steps.StepActivateAndCompleteJob;
import io.camunda.zeebe.test.util.bpmn.random.steps.StepActivateAndFailJob;
import io.camunda.zeebe.test.util.bpmn.random.steps.StepActivateAndTimeoutJob;
import io.camunda.zeebe.test.util.bpmn.random.steps.StepActivateBPMNElement;
import io.camunda.zeebe.test.util.bpmn.random.steps.StepActivateJobAndThrowError;
import io.camunda.zeebe.test.util.bpmn.random.steps.StepTriggerTimerBoundaryEvent;
import java.util.Random;
import java.util.function.Function;

public class JobWorkerTaskBlockBuilder
implements BlockBuilder {
    private final String taskId;
    private final String jobType;
    private final String errorCode;
    private final String boundaryErrorEventId;
    private final String boundaryTimerEventId;
    private final boolean hasBoundaryEvents;
    private final boolean hasBoundaryErrorEvent;
    private final boolean hasBoundaryTimerEvent;
    private final Function<AbstractFlowNodeBuilder<?, ?>, AbstractJobWorkerTaskBuilder<?, ?>> taskBuilder;

    public JobWorkerTaskBlockBuilder(IDGenerator idGenerator, Random random, Function<AbstractFlowNodeBuilder<?, ?>, AbstractJobWorkerTaskBuilder<?, ?>> taskBuilder) {
        this.taskBuilder = taskBuilder;
        this.taskId = idGenerator.nextId();
        this.jobType = "job_" + this.taskId;
        this.errorCode = "error_" + this.taskId;
        this.boundaryErrorEventId = "boundary_error_" + this.taskId;
        this.boundaryTimerEventId = "boundary_timer_" + this.taskId;
        this.hasBoundaryErrorEvent = random.nextDouble() < 0.2;
        this.hasBoundaryTimerEvent = random.nextDouble() < 0.2;
        this.hasBoundaryEvents = this.hasBoundaryErrorEvent || this.hasBoundaryTimerEvent;
    }

    @Override
    public AbstractFlowNodeBuilder<?, ?> buildFlowNodes(AbstractFlowNodeBuilder<?, ?> nodeBuilder) {
        AbstractFlowNodeBuilder jobWorkerTaskBuilder = this.taskBuilder.apply(nodeBuilder);
        ((AbstractJobWorkerTaskBuilder)jobWorkerTaskBuilder.id(this.taskId)).name(this.taskId);
        jobWorkerTaskBuilder.zeebeJobRetries("3");
        jobWorkerTaskBuilder.zeebeJobType(this.jobType);
        AbstractFlowNodeBuilder result = jobWorkerTaskBuilder;
        if (this.hasBoundaryEvents) {
            String joinGatewayId = "boundary_join_" + this.taskId;
            ExclusiveGatewayBuilder exclusiveGatewayBuilder = jobWorkerTaskBuilder.exclusiveGateway(joinGatewayId);
            if (this.hasBoundaryErrorEvent) {
                result = ((AbstractJobWorkerTaskBuilder)exclusiveGatewayBuilder.moveToNode(this.taskId)).boundaryEvent(this.boundaryErrorEventId, b -> b.error(this.errorCode)).connectTo(joinGatewayId);
            }
            if (this.hasBoundaryTimerEvent) {
                result = ((AbstractJobWorkerTaskBuilder)exclusiveGatewayBuilder.moveToNode(this.taskId)).boundaryEvent(this.boundaryTimerEventId, b -> b.timerWithDurationExpression(this.boundaryTimerEventId)).connectTo(joinGatewayId);
            }
        }
        return result;
    }

    @Override
    public ExecutionPathSegment findRandomExecutionPath(Random random) {
        ExecutionPathSegment result = new ExecutionPathSegment();
        StepActivateBPMNElement activateStep = new StepActivateBPMNElement(this.taskId);
        result.appendDirectSuccessor(activateStep);
        if (this.hasBoundaryTimerEvent) {
            result.setVariableDefault(this.boundaryTimerEventId, AbstractExecutionStep.VIRTUALLY_INFINITE.toString());
        }
        result.append(this.buildStepsForFailedExecutions(random));
        result.appendExecutionSuccessor(this.buildStepForSuccessfulExecution(random), activateStep);
        return result;
    }

    private ExecutionPathSegment buildStepsForFailedExecutions(Random random) {
        ExecutionPathSegment result = new ExecutionPathSegment();
        if (!this.hasBoundaryTimerEvent && random.nextBoolean()) {
            result.appendDirectSuccessor(new StepActivateAndTimeoutJob(this.jobType));
        }
        if (random.nextBoolean()) {
            boolean updateRetries = random.nextBoolean();
            result.appendDirectSuccessor(new StepActivateAndFailJob(this.jobType, updateRetries));
        }
        return result;
    }

    private AbstractExecutionStep buildStepForSuccessfulExecution(Random random) {
        AbstractExecutionStep result = this.hasBoundaryErrorEvent && random.nextBoolean() ? new StepActivateJobAndThrowError(this.jobType, this.errorCode) : (this.hasBoundaryTimerEvent && random.nextBoolean() ? new StepTriggerTimerBoundaryEvent(this.jobType, this.boundaryTimerEventId) : new StepActivateAndCompleteJob(this.jobType));
        return result;
    }

    public static BlockBuilderFactory serviceTaskFactory() {
        return new Factory(AbstractFlowNodeBuilder::serviceTask);
    }

    public static BlockBuilderFactory businessRuleTaskFactory() {
        return new Factory(AbstractFlowNodeBuilder::businessRuleTask);
    }

    public static BlockBuilderFactory scriptTaskFactory() {
        return new Factory(AbstractFlowNodeBuilder::scriptTask);
    }

    public static BlockBuilderFactory sendTaskFactory() {
        return new Factory(AbstractFlowNodeBuilder::sendTask);
    }

    private static class Factory
    implements BlockBuilderFactory {
        private final Function<AbstractFlowNodeBuilder<?, ?>, AbstractJobWorkerTaskBuilder<?, ?>> taskBuilder;

        public Factory(Function<AbstractFlowNodeBuilder<?, ?>, AbstractJobWorkerTaskBuilder<?, ?>> taskBuilder) {
            this.taskBuilder = taskBuilder;
        }

        @Override
        public BlockBuilder createBlockBuilder(ConstructionContext context) {
            return new JobWorkerTaskBlockBuilder(context.getIdGenerator(), context.getRandom(), this.taskBuilder);
        }

        @Override
        public boolean isAddingDepth() {
            return false;
        }
    }
}

