/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.test.util.bpmn.random.blocks;

import io.camunda.zeebe.model.bpmn.builder.ProcessBuilder;
import io.camunda.zeebe.model.bpmn.builder.StartEventBuilder;
import io.camunda.zeebe.test.util.bpmn.random.ConstructionContext;
import io.camunda.zeebe.test.util.bpmn.random.ExecutionPathSegment;
import io.camunda.zeebe.test.util.bpmn.random.IDGenerator;
import io.camunda.zeebe.test.util.bpmn.random.StartEventBlockBuilder;
import io.camunda.zeebe.test.util.bpmn.random.steps.StepPublishStartMessage;
import java.util.Map;

public final class MessageStartEventBuilder
implements StartEventBlockBuilder {
    private final String startEventId;
    private final String messageName;

    public MessageStartEventBuilder(ConstructionContext context) {
        IDGenerator idGenerator = context.getIdGenerator();
        this.startEventId = idGenerator.nextId();
        this.messageName = "message_" + this.startEventId;
    }

    public StartEventBuilder buildStartEvent(ProcessBuilder processBuilder) {
        return (StartEventBuilder)processBuilder.startEvent(this.startEventId).message(messageBuilder -> messageBuilder.name(this.messageName));
    }

    @Override
    public ExecutionPathSegment findRandomExecutionPath(String processId, Map<String, Object> variables) {
        ExecutionPathSegment pathSegment = new ExecutionPathSegment();
        pathSegment.appendDirectSuccessor(new StepPublishStartMessage(this.messageName, variables));
        return pathSegment;
    }
}

