/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.test.util.bpmn.random.blocks;

import io.camunda.zeebe.model.bpmn.builder.AbstractFlowNodeBuilder;
import io.camunda.zeebe.model.bpmn.builder.ParallelGatewayBuilder;
import io.camunda.zeebe.test.util.bpmn.random.BlockBuilder;
import io.camunda.zeebe.test.util.bpmn.random.BlockBuilderFactory;
import io.camunda.zeebe.test.util.bpmn.random.ConstructionContext;
import io.camunda.zeebe.test.util.bpmn.random.ExecutionPathSegment;
import io.camunda.zeebe.test.util.bpmn.random.IDGenerator;
import io.camunda.zeebe.test.util.bpmn.random.ScheduledExecutionStep;
import io.camunda.zeebe.test.util.bpmn.random.blocks.BlockSequenceBuilder;
import io.camunda.zeebe.test.util.bpmn.random.steps.StepActivateBPMNElement;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;

public class ParallelGatewayBlockBuilder
implements BlockBuilder {
    private final List<BlockBuilder> blockBuilders = new ArrayList<BlockBuilder>();
    private final List<String> branchIds = new ArrayList<String>();
    private final String forkGatewayId;
    private final String joinGatewayId;

    public ParallelGatewayBlockBuilder(ConstructionContext context) {
        Random random = context.getRandom();
        IDGenerator idGenerator = context.getIdGenerator();
        int maxBranches = context.getMaxBranches();
        this.forkGatewayId = "fork_" + idGenerator.nextId();
        this.joinGatewayId = "join_" + idGenerator.nextId();
        BlockSequenceBuilder.BlockSequenceBuilderFactory blockSequenceBuilderFactory = context.getBlockSequenceBuilderFactory();
        int branches = Math.max(2, random.nextInt(maxBranches));
        for (int i = 0; i < branches; ++i) {
            this.branchIds.add(idGenerator.nextId());
            this.blockBuilders.add(blockSequenceBuilderFactory.createBlockSequenceBuilder(context.withIncrementedDepth()));
        }
    }

    @Override
    public AbstractFlowNodeBuilder<?, ?> buildFlowNodes(AbstractFlowNodeBuilder<?, ?> nodeBuilder) {
        ParallelGatewayBuilder forkGateway = nodeBuilder.parallelGateway(this.forkGatewayId);
        ParallelGatewayBuilder workInProgress = this.blockBuilders.get(0).buildFlowNodes((AbstractFlowNodeBuilder<?, ?>)forkGateway).parallelGateway(this.joinGatewayId);
        for (int i = 1; i < this.blockBuilders.size(); ++i) {
            String edgeId = this.branchIds.get(i);
            BlockBuilder blockBuilder = this.blockBuilders.get(i);
            AbstractFlowNodeBuilder outgoingEdge = workInProgress.moveToNode(this.forkGatewayId).sequenceFlowId(edgeId);
            workInProgress = blockBuilder.buildFlowNodes(outgoingEdge).connectTo(this.joinGatewayId);
        }
        return workInProgress;
    }

    @Override
    public ExecutionPathSegment findRandomExecutionPath(Random random) {
        ExecutionPathSegment result = new ExecutionPathSegment();
        StepActivateBPMNElement forkingGateway = new StepActivateBPMNElement(this.forkGatewayId);
        result.appendDirectSuccessor(forkingGateway);
        List<BranchPointer> branchPointers = this.blockBuilders.stream().map(blockBuilder -> {
            ExecutionPathSegment branchExecutionPath = blockBuilder.findRandomExecutionPath(random);
            result.mergeVariableDefaults(branchExecutionPath);
            return new BranchPointer(branchExecutionPath.getScheduledSteps());
        }).collect(Collectors.toList());
        this.shuffleStepsFromDifferentLists(random, result, branchPointers);
        return result;
    }

    private void shuffleStepsFromDifferentLists(Random random, ExecutionPathSegment executionPath, List<BranchPointer> branchPointers) {
        this.purgeEmptyBranches(branchPointers);
        branchPointers.forEach(branch -> this.copyAutomaticSteps((BranchPointer)branch, executionPath));
        this.purgeEmptyBranches(branchPointers);
        while (!branchPointers.isEmpty()) {
            BranchPointer tuple = branchPointers.get(random.nextInt(branchPointers.size()));
            this.takeNextItemAndAppendToExecutionPath(executionPath, tuple);
            this.copyAutomaticSteps(tuple, executionPath);
            this.purgeEmptyBranches(branchPointers);
        }
    }

    private void takeNextItemAndAppendToExecutionPath(ExecutionPathSegment executionPath, BranchPointer branchPointer) {
        executionPath.append(branchPointer.getRemainingSteps().remove(0));
    }

    private void copyAutomaticSteps(BranchPointer branchPointer, ExecutionPathSegment executionPath) {
        while (branchPointer.remainingSteps.size() > 0 && branchPointer.remainingSteps.get(0).getStep().isAutomatic()) {
            this.takeNextItemAndAppendToExecutionPath(executionPath, branchPointer);
        }
    }

    private void purgeEmptyBranches(List<BranchPointer> branchPointers) {
        branchPointers.removeIf(rec$ -> ((BranchPointer)rec$).isEmpty());
    }

    private static final class BranchPointer {
        private final List<ScheduledExecutionStep> remainingSteps;

        private BranchPointer(List<ScheduledExecutionStep> remainingSteps) {
            this.remainingSteps = new ArrayList<ScheduledExecutionStep>(remainingSteps);
        }

        private List<ScheduledExecutionStep> getRemainingSteps() {
            return this.remainingSteps;
        }

        private boolean isEmpty() {
            return this.remainingSteps.isEmpty();
        }
    }

    public static class Factory
    implements BlockBuilderFactory {
        @Override
        public BlockBuilder createBlockBuilder(ConstructionContext context) {
            return new ParallelGatewayBlockBuilder(context);
        }

        @Override
        public boolean isAddingDepth() {
            return true;
        }
    }
}

