/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.test.util.bpmn.random.blocks;

import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.model.bpmn.builder.AbstractFlowNodeBuilder;
import io.camunda.zeebe.model.bpmn.builder.StartEventBuilder;
import io.camunda.zeebe.test.util.bpmn.random.BlockBuilder;
import io.camunda.zeebe.test.util.bpmn.random.ConstructionContext;
import io.camunda.zeebe.test.util.bpmn.random.ExecutionPath;
import io.camunda.zeebe.test.util.bpmn.random.ExecutionPathSegment;
import io.camunda.zeebe.test.util.bpmn.random.IDGenerator;
import io.camunda.zeebe.test.util.bpmn.random.StartEventBlockBuilder;
import io.camunda.zeebe.test.util.bpmn.random.blocks.MessageStartEventBuilder;
import io.camunda.zeebe.test.util.bpmn.random.blocks.NoneStartEventBuilder;
import io.camunda.zeebe.test.util.bpmn.random.blocks.TimerStartEventBuilder;
import io.camunda.zeebe.test.util.bpmn.random.steps.StepPublishMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Function;

public final class ProcessBuilder {
    private static final String EVENT_SUBPROCESS_CORRELATION_KEY_VALUE = "default_correlation_key";
    private static final List<Function<ConstructionContext, StartEventBlockBuilder>> START_EVENT_BUILDER_FACTORIES = List.of(NoneStartEventBuilder::new, MessageStartEventBuilder::new, TimerStartEventBuilder::new);
    private final BlockBuilder blockBuilder;
    private final StartEventBlockBuilder startEventBuilder;
    private final List<BpmnModelInstance> calledChildModelInstances = new ArrayList<BpmnModelInstance>();
    private final String processId;
    private final String endEventId;
    private final boolean hasEventSubProcess;
    private String eventSubProcessId;
    private boolean isEventSubProcessInterrupting;
    private String eventSubProcessMessageName;

    public ProcessBuilder(ConstructionContext context) {
        ConstructionContext processContext = context.withAddCalledChildProcessCallback(this::onAddCalledChildProcess);
        this.blockBuilder = processContext.getBlockSequenceBuilderFactory().createBlockSequenceBuilder(processContext);
        IDGenerator idGenerator = processContext.getIdGenerator();
        this.processId = "process_" + idGenerator.nextId();
        this.hasEventSubProcess = this.initEventSubProcess(processContext, idGenerator);
        Random random = processContext.getRandom();
        Function<ConstructionContext, StartEventBlockBuilder> startEventBuilderFactory = START_EVENT_BUILDER_FACTORIES.get(random.nextInt(START_EVENT_BUILDER_FACTORIES.size()));
        this.startEventBuilder = startEventBuilderFactory.apply(processContext);
        this.endEventId = idGenerator.nextId();
    }

    public void onAddCalledChildProcess(BpmnModelInstance childModelInstance) {
        this.calledChildModelInstances.add(childModelInstance);
    }

    private boolean initEventSubProcess(ConstructionContext context, IDGenerator idGenerator) {
        boolean hasEventSubProcess = context.getRandom().nextBoolean();
        if (hasEventSubProcess) {
            this.eventSubProcessId = "eventSubProcess_" + idGenerator.nextId();
            this.isEventSubProcessInterrupting = context.getRandom().nextBoolean();
            this.eventSubProcessMessageName = "message_" + this.eventSubProcessId;
        }
        return hasEventSubProcess;
    }

    public List<BpmnModelInstance> buildProcess() {
        ArrayList<BpmnModelInstance> result = new ArrayList<BpmnModelInstance>();
        io.camunda.zeebe.model.bpmn.builder.ProcessBuilder processBuilder = Bpmn.createExecutableProcess((String)this.processId);
        if (this.hasEventSubProcess) {
            this.buildEventSubProcess(processBuilder);
        }
        AbstractFlowNodeBuilder<?, ?> processWorkInProgress = this.startEventBuilder.buildStartEvent(processBuilder);
        processWorkInProgress = this.blockBuilder.buildFlowNodes(processWorkInProgress);
        BpmnModelInstance rootModelInstance = processWorkInProgress.endEvent(this.endEventId).done();
        result.add(rootModelInstance);
        result.addAll(this.calledChildModelInstances);
        return result;
    }

    private void buildEventSubProcess(io.camunda.zeebe.model.bpmn.builder.ProcessBuilder processBuilder) {
        ((StartEventBuilder)((StartEventBuilder)processBuilder.eventSubProcess(this.eventSubProcessId).startEvent("start_event_" + this.eventSubProcessId).interrupting(this.isEventSubProcessInterrupting)).message(b -> b.name(this.eventSubProcessMessageName).zeebeCorrelationKeyExpression("\"default_correlation_key\""))).endEvent("end_event_" + this.eventSubProcessId);
    }

    public ExecutionPath findRandomExecutionPath(Random random) {
        boolean shouldTriggerEventSubProcess;
        ExecutionPathSegment followingPath = this.blockBuilder.findRandomExecutionPath(random);
        if (this.hasEventSubProcess && (shouldTriggerEventSubProcess = random.nextBoolean())) {
            this.executionPathForEventSubProcess(random, followingPath);
        }
        ExecutionPathSegment startPath = this.startEventBuilder.findRandomExecutionPath(this.processId, followingPath.collectVariables());
        startPath.append(followingPath);
        return new ExecutionPath(this.processId, startPath);
    }

    private void executionPathForEventSubProcess(Random random, ExecutionPathSegment followingPath) {
        int size = followingPath.getSteps().size() - 1;
        if (size < 1 || !followingPath.canBeInterrupted()) {
            return;
        }
        StepPublishMessage executionStep = new StepPublishMessage(this.eventSubProcessMessageName, "", EVENT_SUBPROCESS_CORRELATION_KEY_VALUE);
        if (this.isEventSubProcessInterrupting) {
            followingPath.cutAtRandomPosition(random);
            followingPath.appendDirectSuccessor(executionStep);
        } else {
            followingPath.insertExecutionStep(random, executionStep);
        }
    }
}

