/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.test.util.bpmn.random.blocks;

import io.camunda.zeebe.model.bpmn.builder.AbstractFlowNodeBuilder;
import io.camunda.zeebe.model.bpmn.builder.ReceiveTaskBuilder;
import io.camunda.zeebe.test.util.bpmn.random.BlockBuilder;
import io.camunda.zeebe.test.util.bpmn.random.BlockBuilderFactory;
import io.camunda.zeebe.test.util.bpmn.random.ConstructionContext;
import io.camunda.zeebe.test.util.bpmn.random.ExecutionPathSegment;
import io.camunda.zeebe.test.util.bpmn.random.IDGenerator;
import io.camunda.zeebe.test.util.bpmn.random.steps.StepPublishMessage;
import java.util.Random;

public class ReceiveTaskBlockBuilder
implements BlockBuilder {
    private static final String CORRELATION_KEY_FIELD = "correlationKey";
    private static final String CORRELATION_KEY_VALUE = "default_correlation_key";
    private final String id;
    private final String messageName;

    public ReceiveTaskBlockBuilder(IDGenerator idGenerator) {
        this.id = idGenerator.nextId();
        this.messageName = "message_" + this.id;
    }

    @Override
    public AbstractFlowNodeBuilder<?, ?> buildFlowNodes(AbstractFlowNodeBuilder<?, ?> nodeBuilder) {
        ReceiveTaskBuilder receiveTask = nodeBuilder.receiveTask(this.id);
        receiveTask.message(messageBuilder -> {
            messageBuilder.zeebeCorrelationKeyExpression(CORRELATION_KEY_FIELD);
            messageBuilder.name(this.messageName);
        });
        return receiveTask;
    }

    @Override
    public ExecutionPathSegment findRandomExecutionPath(Random random) {
        ExecutionPathSegment result = new ExecutionPathSegment();
        result.appendDirectSuccessor(new StepPublishMessage(this.messageName, CORRELATION_KEY_FIELD, CORRELATION_KEY_VALUE));
        return result;
    }

    public static class Factory
    implements BlockBuilderFactory {
        @Override
        public BlockBuilder createBlockBuilder(ConstructionContext context) {
            return new ReceiveTaskBlockBuilder(context.getIdGenerator());
        }

        @Override
        public boolean isAddingDepth() {
            return false;
        }
    }
}

