/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.test.util.bpmn.random.blocks;

import io.camunda.zeebe.model.bpmn.builder.AbstractFlowNodeBuilder;
import io.camunda.zeebe.model.bpmn.builder.ExclusiveGatewayBuilder;
import io.camunda.zeebe.model.bpmn.builder.SubProcessBuilder;
import io.camunda.zeebe.test.util.bpmn.random.BlockBuilder;
import io.camunda.zeebe.test.util.bpmn.random.BlockBuilderFactory;
import io.camunda.zeebe.test.util.bpmn.random.ConstructionContext;
import io.camunda.zeebe.test.util.bpmn.random.ExecutionPathSegment;
import io.camunda.zeebe.test.util.bpmn.random.IDGenerator;
import io.camunda.zeebe.test.util.bpmn.random.blocks.BlockSequenceBuilder;
import io.camunda.zeebe.test.util.bpmn.random.steps.AbstractExecutionStep;
import io.camunda.zeebe.test.util.bpmn.random.steps.StepActivateBPMNElement;
import io.camunda.zeebe.test.util.bpmn.random.steps.StepTriggerTimerBoundaryEvent;
import java.util.Random;

public class SubProcessBlockBuilder
implements BlockBuilder {
    private BlockBuilder embeddedSubProcessBuilder;
    private final String subProcessId;
    private final String subProcessStartEventId;
    private final String subProcessEndEventId;
    private final String subProcessBoundaryTimerEventId;
    private final boolean hasBoundaryEvents;
    private final boolean hasBoundaryTimerEvent;

    public SubProcessBlockBuilder(ConstructionContext context) {
        boolean goDeeper;
        Random random = context.getRandom();
        IDGenerator idGenerator = context.getIdGenerator();
        BlockSequenceBuilder.BlockSequenceBuilderFactory factory = context.getBlockSequenceBuilderFactory();
        int maxDepth = context.getMaxDepth();
        int currentDepth = context.getCurrentDepth();
        this.subProcessId = idGenerator.nextId();
        this.subProcessStartEventId = idGenerator.nextId();
        this.subProcessEndEventId = idGenerator.nextId();
        this.subProcessBoundaryTimerEventId = "boundary_timer_" + this.subProcessId;
        boolean bl = goDeeper = random.nextInt(maxDepth) > currentDepth;
        if (goDeeper) {
            this.embeddedSubProcessBuilder = factory.createBlockSequenceBuilder(context.withIncrementedDepth());
            this.hasBoundaryTimerEvent = random.nextDouble() < 0.2;
        } else {
            this.hasBoundaryTimerEvent = false;
        }
        this.hasBoundaryEvents = this.hasBoundaryTimerEvent;
    }

    @Override
    public AbstractFlowNodeBuilder<?, ?> buildFlowNodes(AbstractFlowNodeBuilder<?, ?> nodeBuilder) {
        SubProcessBuilder subProcessBuilderDone;
        SubProcessBuilder subProcessBuilderStart = nodeBuilder.subProcess(this.subProcessId);
        AbstractFlowNodeBuilder<?, ?> workInProgress = subProcessBuilderStart.embeddedSubProcess().startEvent(this.subProcessStartEventId);
        if (this.embeddedSubProcessBuilder != null) {
            workInProgress = this.embeddedSubProcessBuilder.buildFlowNodes(workInProgress);
        }
        SubProcessBuilder result = subProcessBuilderDone = workInProgress.endEvent(this.subProcessEndEventId).subProcessDone();
        if (this.hasBoundaryEvents) {
            String joinGatewayId = "boundary_join_" + this.subProcessId;
            ExclusiveGatewayBuilder exclusiveGatewayBuilder = subProcessBuilderDone.exclusiveGateway(joinGatewayId);
            if (this.hasBoundaryTimerEvent) {
                result = ((SubProcessBuilder)exclusiveGatewayBuilder.moveToNode(this.subProcessId)).boundaryEvent(this.subProcessBoundaryTimerEventId, b -> b.timerWithDurationExpression(this.subProcessBoundaryTimerEventId)).connectTo(joinGatewayId);
            }
        }
        return result;
    }

    @Override
    public ExecutionPathSegment findRandomExecutionPath(Random random) {
        ExecutionPathSegment result = new ExecutionPathSegment();
        if (this.hasBoundaryTimerEvent) {
            result.setVariableDefault(this.subProcessBoundaryTimerEventId, AbstractExecutionStep.VIRTUALLY_INFINITE.toString());
        }
        StepActivateBPMNElement activateSubProcess = new StepActivateBPMNElement(this.subProcessId);
        result.appendDirectSuccessor(activateSubProcess);
        if (this.embeddedSubProcessBuilder == null) {
            return result;
        }
        ExecutionPathSegment internalExecutionPath = this.embeddedSubProcessBuilder.findRandomExecutionPath(random);
        if (!this.hasBoundaryEvents || !internalExecutionPath.canBeInterrupted() || random.nextBoolean()) {
            result.append(internalExecutionPath);
        } else {
            internalExecutionPath.cutAtRandomPosition(random);
            result.append(internalExecutionPath);
            if (this.hasBoundaryTimerEvent) {
                result.appendExecutionSuccessor(new StepTriggerTimerBoundaryEvent(this.subProcessId, this.subProcessBoundaryTimerEventId), activateSubProcess);
            }
        }
        return result;
    }

    public static class Factory
    implements BlockBuilderFactory {
        @Override
        public BlockBuilder createBlockBuilder(ConstructionContext context) {
            return new SubProcessBlockBuilder(context);
        }

        @Override
        public boolean isAddingDepth() {
            return true;
        }
    }
}

