/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.test.util.bpmn.random.blocks;

import io.camunda.zeebe.model.bpmn.builder.AbstractFlowNodeBuilder;
import io.camunda.zeebe.model.bpmn.builder.ProcessBuilder;
import io.camunda.zeebe.model.bpmn.builder.StartEventBuilder;
import io.camunda.zeebe.test.util.bpmn.random.ConstructionContext;
import io.camunda.zeebe.test.util.bpmn.random.ExecutionPathSegment;
import io.camunda.zeebe.test.util.bpmn.random.IDGenerator;
import io.camunda.zeebe.test.util.bpmn.random.StartEventBlockBuilder;
import io.camunda.zeebe.test.util.bpmn.random.steps.StepActivateAndCompleteJob;
import io.camunda.zeebe.test.util.bpmn.random.steps.StepTriggerTimerStartEvent;
import java.time.Duration;
import java.util.Map;

public class TimerStartEventBuilder
implements StartEventBlockBuilder {
    private static final String VARIABLES_JOB_TYPE_SUFFIX = "_variables";
    private final String startEventId;
    private final Duration timeToAdd;

    public TimerStartEventBuilder(ConstructionContext context) {
        IDGenerator idGenerator = context.getIdGenerator();
        this.startEventId = idGenerator.nextId();
        this.timeToAdd = Duration.ofMinutes((long)context.getRandom().nextInt(60) + 5L);
    }

    @Override
    public AbstractFlowNodeBuilder<?, ?> buildStartEvent(ProcessBuilder processBuilder) {
        String dateExpression = String.format("now() + duration(\"%s\")", this.timeToAdd);
        return ((StartEventBuilder)processBuilder.startEvent(this.startEventId).timerWithDateExpression(dateExpression)).serviceTask(this.startEventId + "_variables_task", b -> b.zeebeJobType(this.startEventId + VARIABLES_JOB_TYPE_SUFFIX));
    }

    @Override
    public ExecutionPathSegment findRandomExecutionPath(String processId, Map<String, Object> variables) {
        ExecutionPathSegment pathSegment = new ExecutionPathSegment();
        pathSegment.appendDirectSuccessor(new StepTriggerTimerStartEvent(this.timeToAdd));
        pathSegment.appendDirectSuccessor(new StepActivateAndCompleteJob(this.startEventId + VARIABLES_JOB_TYPE_SUFFIX, variables));
        return pathSegment;
    }
}

