/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.test.util.record;

import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceCreationIntent;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceCreationRecordValue;
import io.camunda.zeebe.test.util.collection.Maps;
import io.camunda.zeebe.test.util.record.ExporterRecordStream;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Stream;

public final class ProcessInstanceCreationRecordStream
extends ExporterRecordStream<ProcessInstanceCreationRecordValue, ProcessInstanceCreationRecordStream> {
    public ProcessInstanceCreationRecordStream(Stream<Record<ProcessInstanceCreationRecordValue>> wrappedStream) {
        super(wrappedStream);
    }

    @Override
    protected ProcessInstanceCreationRecordStream supply(Stream<Record<ProcessInstanceCreationRecordValue>> wrappedStream) {
        return new ProcessInstanceCreationRecordStream(wrappedStream);
    }

    public ProcessInstanceCreationRecordStream withBpmnProcessId(String bpmnProcessId) {
        return (ProcessInstanceCreationRecordStream)this.valueFilter(v -> v.getBpmnProcessId().equals(bpmnProcessId));
    }

    public ProcessInstanceCreationRecordStream withVersion(int version) {
        return (ProcessInstanceCreationRecordStream)this.valueFilter(v -> v.getVersion() == version);
    }

    public ProcessInstanceCreationRecordStream withKey(long key) {
        return (ProcessInstanceCreationRecordStream)this.valueFilter(v -> v.getProcessDefinitionKey() == key);
    }

    public ProcessInstanceCreationRecordStream withInstanceKey(long instanceKey) {
        return (ProcessInstanceCreationRecordStream)this.valueFilter(v -> v.getProcessInstanceKey() == instanceKey);
    }

    public ProcessInstanceCreationRecordStream withVariables(Map<String, Object> variables) {
        return (ProcessInstanceCreationRecordStream)this.valueFilter(v -> v.getVariables().equals(variables));
    }

    public ProcessInstanceCreationRecordStream withVariables(Map.Entry<String, Object> ... entries) {
        return this.withVariables(Maps.of(entries));
    }

    public ProcessInstanceCreationRecordStream withVariables(Predicate<Map<String, Object>> matcher) {
        return (ProcessInstanceCreationRecordStream)this.valueFilter(v -> matcher.test(v.getVariables()));
    }

    public ProcessInstanceCreationRecordStream limitToProcessInstanceCreated(long processInstanceKey) {
        return (ProcessInstanceCreationRecordStream)this.limit(r -> r.getIntent() == ProcessInstanceCreationIntent.CREATED && ((ProcessInstanceCreationRecordValue)r.getValue()).getProcessInstanceKey() == processInstanceKey);
    }
}

