/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.test.util.record;

import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRecordValue;
import io.camunda.zeebe.test.util.record.ExporterRecordStream;
import java.util.stream.Stream;

public final class ProcessInstanceRecordStream
extends ExporterRecordStream<ProcessInstanceRecordValue, ProcessInstanceRecordStream> {
    public ProcessInstanceRecordStream(Stream<Record<ProcessInstanceRecordValue>> stream) {
        super(stream);
    }

    @Override
    protected ProcessInstanceRecordStream supply(Stream<Record<ProcessInstanceRecordValue>> stream) {
        return new ProcessInstanceRecordStream(stream);
    }

    public ProcessInstanceRecordStream withBpmnProcessId(String bpmnProcessId) {
        return (ProcessInstanceRecordStream)this.valueFilter(v -> bpmnProcessId.equals(v.getBpmnProcessId()));
    }

    public ProcessInstanceRecordStream withVersion(int version) {
        return (ProcessInstanceRecordStream)this.valueFilter(v -> v.getVersion() == version);
    }

    public ProcessInstanceRecordStream withProcessDefinitionKey(long processDefinitionKey) {
        return (ProcessInstanceRecordStream)this.valueFilter(v -> v.getProcessDefinitionKey() == processDefinitionKey);
    }

    public ProcessInstanceRecordStream withProcessInstanceKey(long processInstanceKey) {
        return (ProcessInstanceRecordStream)this.valueFilter(v -> v.getProcessInstanceKey() == processInstanceKey);
    }

    public ProcessInstanceRecordStream withElementId(String elementId) {
        return (ProcessInstanceRecordStream)this.valueFilter(v -> elementId.equals(v.getElementId()));
    }

    public ProcessInstanceRecordStream withFlowScopeKey(long flowScopeKey) {
        return (ProcessInstanceRecordStream)this.valueFilter(v -> v.getFlowScopeKey() == flowScopeKey);
    }

    public ProcessInstanceRecordStream limitToProcessInstanceCompleted() {
        return (ProcessInstanceRecordStream)this.limit(r -> r.getIntent() == ProcessInstanceIntent.ELEMENT_COMPLETED && r.getKey() == ((ProcessInstanceRecordValue)r.getValue()).getProcessInstanceKey());
    }

    public ProcessInstanceRecordStream limitToProcessInstanceTerminated() {
        return (ProcessInstanceRecordStream)this.limit(r -> r.getIntent() == ProcessInstanceIntent.ELEMENT_TERMINATED && r.getKey() == ((ProcessInstanceRecordValue)r.getValue()).getProcessInstanceKey());
    }

    public ProcessInstanceRecordStream withElementType(BpmnElementType elementType) {
        return (ProcessInstanceRecordStream)this.valueFilter(v -> v.getBpmnElementType() == elementType);
    }

    public ProcessInstanceRecordStream withParentProcessInstanceKey(long parentProcessInstanceKey) {
        return (ProcessInstanceRecordStream)this.valueFilter(v -> v.getParentProcessInstanceKey() == parentProcessInstanceKey);
    }

    public ProcessInstanceRecordStream withParentElementInstanceKey(long parentElementInstanceKey) {
        return (ProcessInstanceRecordStream)this.valueFilter(v -> v.getParentElementInstanceKey() == parentElementInstanceKey);
    }

    public ProcessInstanceRecordStream filterRootScope() {
        return (ProcessInstanceRecordStream)this.filter((T r) -> r.getKey() == ((ProcessInstanceRecordValue)r.getValue()).getProcessInstanceKey());
    }
}

