/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.test.util.record;

import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.test.util.record.CompactRecordLogger;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecordLogger {
    public static final String STYLE_PROPERTY = "RECORD_LOGGER_STYLE";
    public static final String STYLE_RAW = "RAW";
    public static final Logger LOG = LoggerFactory.getLogger((String)"io.camunda.zeebe.test");

    public static void logRecords() {
        LOG.info("Test failed, following records were exported:");
        if (STYLE_RAW.equals(System.getenv(STYLE_PROPERTY))) {
            RecordLogger.logRecordsRaw(RecordingExporter.getRecords());
        } else {
            RecordLogger.logRecordsCompact(RecordingExporter.getRecords());
        }
    }

    public static void logRecordsCompact(Collection<Record<?>> records) {
        new CompactRecordLogger(records).log();
    }

    public static void logRecordsRaw(Collection<Record<?>> records) {
        records.forEach(r -> LOG.info(r.toString()));
    }
}

