/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.test.util.record;

import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.RecordValue;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.test.util.record.ExporterRecordStream;
import io.camunda.zeebe.test.util.record.IncidentRecordStream;
import io.camunda.zeebe.test.util.record.JobRecordStream;
import io.camunda.zeebe.test.util.record.MessageSubscriptionRecordStream;
import io.camunda.zeebe.test.util.record.ProcessInstanceRecordStream;
import io.camunda.zeebe.test.util.record.TimerRecordStream;
import io.camunda.zeebe.test.util.record.VariableDocumentRecordStream;
import io.camunda.zeebe.test.util.record.VariableRecordStream;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;

public final class RecordStream
extends ExporterRecordStream<RecordValue, RecordStream> {
    public RecordStream(Stream<Record<RecordValue>> wrappedStream) {
        super(wrappedStream);
    }

    @Override
    protected RecordStream supply(Stream<Record<RecordValue>> wrappedStream) {
        return new RecordStream(wrappedStream);
    }

    public RecordStream between(long lowerBoundPosition, long upperBoundPosition) {
        return this.between((Record<?> r) -> r.getPosition() > lowerBoundPosition, (Record<?> r) -> r.getPosition() >= upperBoundPosition);
    }

    public RecordStream between(Record<?> lowerBound, Record<?> upperBound) {
        return this.between(lowerBound::equals, upperBound::equals);
    }

    public RecordStream between(Predicate<Record<?>> lowerBound, Predicate<Record<?>> upperBound) {
        return (RecordStream)((RecordStream)this.limit(upperBound::test)).skipUntil(lowerBound::test);
    }

    public RecordStream limitToProcessInstance(long processInstanceKey) {
        return this.between((Record<?> r) -> r.getKey() == processInstanceKey && r.getIntent() == ProcessInstanceIntent.ELEMENT_ACTIVATING, (Record<?> r) -> r.getKey() == processInstanceKey && Set.of(ProcessInstanceIntent.ELEMENT_COMPLETED, ProcessInstanceIntent.ELEMENT_TERMINATED).contains(r.getIntent()));
    }

    public ProcessInstanceRecordStream processInstanceRecords() {
        return new ProcessInstanceRecordStream(((RecordStream)this.filter((T r) -> r.getValueType() == ValueType.PROCESS_INSTANCE)).map(Record.class::cast));
    }

    public TimerRecordStream timerRecords() {
        return new TimerRecordStream(((RecordStream)this.filter((T r) -> r.getValueType() == ValueType.TIMER)).map(Record.class::cast));
    }

    public VariableDocumentRecordStream variableDocumentRecords() {
        return new VariableDocumentRecordStream(((RecordStream)this.filter((T r) -> r.getValueType() == ValueType.VARIABLE_DOCUMENT)).map(Record.class::cast));
    }

    public VariableRecordStream variableRecords() {
        return new VariableRecordStream(((RecordStream)this.filter((T r) -> r.getValueType() == ValueType.VARIABLE)).map(Record.class::cast));
    }

    public JobRecordStream jobRecords() {
        return new JobRecordStream(((RecordStream)this.filter((T r) -> r.getValueType() == ValueType.JOB)).map(Record.class::cast));
    }

    public IncidentRecordStream incidentRecords() {
        return new IncidentRecordStream(((RecordStream)this.filter((T r) -> r.getValueType() == ValueType.INCIDENT)).map(Record.class::cast));
    }

    public MessageSubscriptionRecordStream messageSubscriptionRecords() {
        return new MessageSubscriptionRecordStream(((RecordStream)this.filter((T r) -> r.getValueType() == ValueType.MESSAGE_SUBSCRIPTION)).map(Record.class::cast));
    }
}

