/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.test.util.record;

import io.camunda.zeebe.exporter.api.Exporter;
import io.camunda.zeebe.exporter.api.context.Controller;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.RecordValue;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.DeploymentIntent;
import io.camunda.zeebe.protocol.record.intent.IncidentIntent;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.JobBatchIntent;
import io.camunda.zeebe.protocol.record.intent.JobIntent;
import io.camunda.zeebe.protocol.record.intent.MessageIntent;
import io.camunda.zeebe.protocol.record.intent.MessageStartEventSubscriptionIntent;
import io.camunda.zeebe.protocol.record.intent.MessageSubscriptionIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessMessageSubscriptionIntent;
import io.camunda.zeebe.protocol.record.intent.TimerIntent;
import io.camunda.zeebe.protocol.record.intent.VariableDocumentIntent;
import io.camunda.zeebe.protocol.record.intent.VariableIntent;
import io.camunda.zeebe.protocol.record.value.DeploymentDistributionRecordValue;
import io.camunda.zeebe.protocol.record.value.DeploymentRecordValue;
import io.camunda.zeebe.protocol.record.value.IncidentRecordValue;
import io.camunda.zeebe.protocol.record.value.JobBatchRecordValue;
import io.camunda.zeebe.protocol.record.value.JobRecordValue;
import io.camunda.zeebe.protocol.record.value.MessageRecordValue;
import io.camunda.zeebe.protocol.record.value.MessageStartEventSubscriptionRecordValue;
import io.camunda.zeebe.protocol.record.value.MessageSubscriptionRecordValue;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceCreationRecordValue;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRecordValue;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceResultRecordValue;
import io.camunda.zeebe.protocol.record.value.ProcessMessageSubscriptionRecordValue;
import io.camunda.zeebe.protocol.record.value.TimerRecordValue;
import io.camunda.zeebe.protocol.record.value.VariableDocumentRecordValue;
import io.camunda.zeebe.protocol.record.value.VariableRecordValue;
import io.camunda.zeebe.protocol.record.value.deployment.Process;
import io.camunda.zeebe.test.util.record.DeploymentDistributionRecordStream;
import io.camunda.zeebe.test.util.record.DeploymentRecordStream;
import io.camunda.zeebe.test.util.record.IncidentRecordStream;
import io.camunda.zeebe.test.util.record.JobBatchRecordStream;
import io.camunda.zeebe.test.util.record.JobRecordStream;
import io.camunda.zeebe.test.util.record.MessageRecordStream;
import io.camunda.zeebe.test.util.record.MessageStartEventSubscriptionRecordStream;
import io.camunda.zeebe.test.util.record.MessageSubscriptionRecordStream;
import io.camunda.zeebe.test.util.record.ProcessInstanceCreationRecordStream;
import io.camunda.zeebe.test.util.record.ProcessInstanceRecordStream;
import io.camunda.zeebe.test.util.record.ProcessInstanceResultRecordStream;
import io.camunda.zeebe.test.util.record.ProcessMessageSubscriptionRecordStream;
import io.camunda.zeebe.test.util.record.ProcessRecordStream;
import io.camunda.zeebe.test.util.record.RecordStream;
import io.camunda.zeebe.test.util.record.TimerRecordStream;
import io.camunda.zeebe.test.util.record.VariableDocumentRecordStream;
import io.camunda.zeebe.test.util.record.VariableRecordStream;
import java.time.Duration;
import java.util.Iterator;
import java.util.List;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public final class RecordingExporter
implements Exporter {
    public static final long DEFAULT_MAX_WAIT_TIME = Duration.ofSeconds(5L).toMillis();
    private static final List<Record<?>> RECORDS = new CopyOnWriteArrayList();
    private static final Lock LOCK = new ReentrantLock();
    private static final Condition IS_EMPTY = LOCK.newCondition();
    private static long maximumWaitTime = DEFAULT_MAX_WAIT_TIME;
    private Controller controller;

    public static void setMaximumWaitTime(long maximumWaitTime) {
        RecordingExporter.maximumWaitTime = maximumWaitTime;
    }

    public void open(Controller controller) {
        this.controller = controller;
    }

    public void export(Record<?> record) {
        LOCK.lock();
        try {
            RECORDS.add(record.clone());
            IS_EMPTY.signal();
            if (this.controller != null) {
                this.controller.updateLastExportedRecordPosition(record.getPosition());
            }
        }
        finally {
            LOCK.unlock();
        }
    }

    public static List<Record<?>> getRecords() {
        return RECORDS;
    }

    public static void reset() {
        LOCK.lock();
        try {
            RECORDS.clear();
        }
        finally {
            LOCK.unlock();
        }
    }

    protected static <T extends RecordValue> Stream<Record<T>> records(ValueType valueType, Class<T> valueClass) {
        Spliterator spliterator = Spliterators.spliteratorUnknownSize(new RecordIterator(), 16);
        return StreamSupport.stream(spliterator, false).filter(r -> r.getValueType() == valueType).map(r -> r);
    }

    public static RecordStream records() {
        Spliterator spliterator = Spliterators.spliteratorUnknownSize(new RecordIterator(), 16);
        return new RecordStream(StreamSupport.stream(spliterator, false).map(r -> r));
    }

    public static MessageSubscriptionRecordStream messageSubscriptionRecords() {
        return new MessageSubscriptionRecordStream(RecordingExporter.records(ValueType.MESSAGE_SUBSCRIPTION, MessageSubscriptionRecordValue.class));
    }

    public static MessageSubscriptionRecordStream messageSubscriptionRecords(MessageSubscriptionIntent intent) {
        return (MessageSubscriptionRecordStream)RecordingExporter.messageSubscriptionRecords().withIntent((Intent)intent);
    }

    public static MessageStartEventSubscriptionRecordStream messageStartEventSubscriptionRecords() {
        return new MessageStartEventSubscriptionRecordStream(RecordingExporter.records(ValueType.MESSAGE_START_EVENT_SUBSCRIPTION, MessageStartEventSubscriptionRecordValue.class));
    }

    public static MessageStartEventSubscriptionRecordStream messageStartEventSubscriptionRecords(MessageStartEventSubscriptionIntent intent) {
        return (MessageStartEventSubscriptionRecordStream)RecordingExporter.messageStartEventSubscriptionRecords().withIntent((Intent)intent);
    }

    public static DeploymentRecordStream deploymentRecords() {
        return new DeploymentRecordStream(RecordingExporter.records(ValueType.DEPLOYMENT, DeploymentRecordValue.class));
    }

    public static DeploymentRecordStream deploymentRecords(DeploymentIntent intent) {
        return (DeploymentRecordStream)RecordingExporter.deploymentRecords().withIntent((Intent)intent);
    }

    public static ProcessRecordStream processRecords() {
        return new ProcessRecordStream(RecordingExporter.records(ValueType.PROCESS, Process.class));
    }

    public static DeploymentDistributionRecordStream deploymentDistributionRecords() {
        return new DeploymentDistributionRecordStream(RecordingExporter.records(ValueType.DEPLOYMENT_DISTRIBUTION, DeploymentDistributionRecordValue.class));
    }

    public static JobRecordStream jobRecords() {
        return new JobRecordStream(RecordingExporter.records(ValueType.JOB, JobRecordValue.class));
    }

    public static JobRecordStream jobRecords(JobIntent intent) {
        return (JobRecordStream)RecordingExporter.jobRecords().withIntent((Intent)intent);
    }

    public static JobBatchRecordStream jobBatchRecords() {
        return new JobBatchRecordStream(RecordingExporter.records(ValueType.JOB_BATCH, JobBatchRecordValue.class));
    }

    public static JobBatchRecordStream jobBatchRecords(JobBatchIntent intent) {
        return (JobBatchRecordStream)RecordingExporter.jobBatchRecords().withIntent((Intent)intent);
    }

    public static IncidentRecordStream incidentRecords() {
        return new IncidentRecordStream(RecordingExporter.records(ValueType.INCIDENT, IncidentRecordValue.class));
    }

    public static IncidentRecordStream incidentRecords(IncidentIntent intent) {
        return (IncidentRecordStream)RecordingExporter.incidentRecords().withIntent((Intent)intent);
    }

    public static ProcessMessageSubscriptionRecordStream processMessageSubscriptionRecords() {
        return new ProcessMessageSubscriptionRecordStream(RecordingExporter.records(ValueType.PROCESS_MESSAGE_SUBSCRIPTION, ProcessMessageSubscriptionRecordValue.class));
    }

    public static ProcessMessageSubscriptionRecordStream processMessageSubscriptionRecords(ProcessMessageSubscriptionIntent intent) {
        return (ProcessMessageSubscriptionRecordStream)RecordingExporter.processMessageSubscriptionRecords().withIntent((Intent)intent);
    }

    public static MessageRecordStream messageRecords() {
        return new MessageRecordStream(RecordingExporter.records(ValueType.MESSAGE, MessageRecordValue.class));
    }

    public static MessageRecordStream messageRecords(MessageIntent intent) {
        return (MessageRecordStream)RecordingExporter.messageRecords().withIntent((Intent)intent);
    }

    public static ProcessInstanceRecordStream processInstanceRecords() {
        return new ProcessInstanceRecordStream(RecordingExporter.records(ValueType.PROCESS_INSTANCE, ProcessInstanceRecordValue.class));
    }

    public static ProcessInstanceRecordStream processInstanceRecords(ProcessInstanceIntent intent) {
        return (ProcessInstanceRecordStream)RecordingExporter.processInstanceRecords().withIntent((Intent)intent);
    }

    public static TimerRecordStream timerRecords() {
        return new TimerRecordStream(RecordingExporter.records(ValueType.TIMER, TimerRecordValue.class));
    }

    public static TimerRecordStream timerRecords(TimerIntent intent) {
        return (TimerRecordStream)RecordingExporter.timerRecords().withIntent((Intent)intent);
    }

    public static VariableRecordStream variableRecords() {
        return new VariableRecordStream(RecordingExporter.records(ValueType.VARIABLE, VariableRecordValue.class));
    }

    public static VariableRecordStream variableRecords(VariableIntent intent) {
        return (VariableRecordStream)RecordingExporter.variableRecords().withIntent((Intent)intent);
    }

    public static VariableDocumentRecordStream variableDocumentRecords() {
        return new VariableDocumentRecordStream(RecordingExporter.records(ValueType.VARIABLE_DOCUMENT, VariableDocumentRecordValue.class));
    }

    public static VariableDocumentRecordStream variableDocumentRecords(VariableDocumentIntent intent) {
        return (VariableDocumentRecordStream)RecordingExporter.variableDocumentRecords().withIntent((Intent)intent);
    }

    public static ProcessInstanceCreationRecordStream processInstanceCreationRecords() {
        return new ProcessInstanceCreationRecordStream(RecordingExporter.records(ValueType.PROCESS_INSTANCE_CREATION, ProcessInstanceCreationRecordValue.class));
    }

    public static ProcessInstanceResultRecordStream processInstanceResultRecords() {
        return new ProcessInstanceResultRecordStream(RecordingExporter.records(ValueType.PROCESS_INSTANCE_RESULT, ProcessInstanceResultRecordValue.class));
    }

    public static class RecordIterator
    implements Iterator<Record<?>> {
        private int nextIndex = 0;

        private boolean isEmpty() {
            return this.nextIndex >= RECORDS.size();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasNext() {
            LOCK.lock();
            try {
                long now = System.currentTimeMillis();
                long endTime = now + maximumWaitTime;
                while (this.isEmpty() && endTime > now) {
                    long waitTime = endTime - now;
                    try {
                        IS_EMPTY.await(waitTime, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    now = System.currentTimeMillis();
                }
                boolean bl = !this.isEmpty();
                return bl;
            }
            finally {
                LOCK.unlock();
            }
        }

        @Override
        public Record<?> next() {
            return RECORDS.get(this.nextIndex++);
        }
    }
}

