/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.test.util.socket;

import io.camunda.zeebe.test.util.socket.SocketUtil;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.util.Iterator;

class PortRange
implements Iterator<InetSocketAddress> {
    private final String host;
    private final int basePort;
    private final int maxOffset;
    private final int forkNumber;
    private int currentOffset;

    PortRange(String host, int forkNumber, int min, int max) {
        assert (max <= 65535) : "Port range exceeds maximal available port 65535, got max port " + max;
        this.host = host;
        this.basePort = min;
        this.maxOffset = max - min;
        this.forkNumber = forkNumber;
        this.currentOffset = 0;
    }

    @Override
    public boolean hasNext() {
        return true;
    }

    @Override
    public InetSocketAddress next() {
        return new InetSocketAddress(this.host, this.nextPort());
    }

    private int nextPort() {
        int next;
        while (!this.portAvailable(next = this.basePort + this.currentOffset++ % this.maxOffset)) {
        }
        SocketUtil.LOG.info("Choosing next port {} for test fork {} with range {}", new Object[]{next, this.forkNumber, this});
        return next;
    }

    private boolean portAvailable(int port) {
        boolean bl;
        ServerSocket ss = new ServerSocket(port);
        try {
            ss.setReuseAddress(true);
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ss.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException iOException) {
                return false;
            }
        }
        ss.close();
        return bl;
    }

    public String toString() {
        return "PortRange{host='" + this.host + "', basePort=" + this.basePort + ", maxOffset=" + this.maxOffset + ", currentOffset=" + this.currentOffset + "}";
    }
}

