/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.test.util.socket;

import io.camunda.zeebe.test.util.TestEnvironment;
import io.camunda.zeebe.test.util.socket.PortRange;
import java.net.InetSocketAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SocketUtil {
    static final Logger LOG = LoggerFactory.getLogger((String)"io.camunda.zeebe.test.util.SocketUtil");
    private static final String DEFAULT_HOST = "localhost";
    private static final int DOCKER_BASE_PORT = 32768;
    private static final int BASE_PORT = 1025;
    private static final int MAX_TEST_STAGES = 10;
    private static final int MAX_TEST_FORKS_PER_STAGE = 30;
    private static final int PORT_RANGE_PER_TEST_FORK = 100;
    private static final int PORT_RANGE_PER_TEST_STAGE = 3000;
    private static final int TEST_FORK_NUMBER;
    private static final PortRange PORT_RANGE;

    private SocketUtil() {
    }

    public static synchronized InetSocketAddress getNextAddress() {
        return PORT_RANGE.next();
    }

    static {
        int testForkNumber = TestEnvironment.getTestForkNumber();
        int testMavenId = TestEnvironment.getTestMavenId();
        LOG.info("Starting socket assignment with testForkNumber {} and testMavenId {}", (Object)testForkNumber, (Object)testMavenId);
        assert (testForkNumber < 30) : "System property test fork number has to be smaller than 30";
        assert (testMavenId < 10) : "System property test maven id has to be smaller than 10";
        int absoluteMaxPort = 31025;
        int testOffset = testMavenId * 3000 + testForkNumber * 100;
        int min = 1025 + testOffset;
        int max = min + 100;
        TEST_FORK_NUMBER = testForkNumber;
        PORT_RANGE = new PortRange(DEFAULT_HOST, TEST_FORK_NUMBER, min, max);
    }
}

