/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.test.util.stream;

import io.camunda.zeebe.test.util.stream.StreamWrapperException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Spliterator;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;

public abstract class StreamWrapper<T, S extends StreamWrapper<T, S>>
implements Stream<T> {
    private final Stream<T> wrappedStream;

    public StreamWrapper(Stream<T> wrappedStream) {
        this.wrappedStream = wrappedStream;
    }

    protected abstract S supply(Stream<T> var1);

    public S skipUntil(Predicate<T> predicate) {
        return this.supply(this.dropWhile(predicate.negate()));
    }

    public S limit(Predicate<T> predicate) {
        ArrayList records = new ArrayList();
        this.wrappedStream.peek(records::add).filter(predicate).findFirst();
        return this.supply(records.stream());
    }

    public boolean exists() {
        return this.wrappedStream.findFirst().isPresent();
    }

    public void await() {
        if (!this.exists()) {
            throw new StreamWrapperException();
        }
    }

    public T getFirst() {
        return this.wrappedStream.findFirst().orElseThrow(StreamWrapperException::new);
    }

    public T getLast() {
        List<T> list = this.asList();
        if (list.isEmpty()) {
            throw new StreamWrapperException();
        }
        return list.get(list.size() - 1);
    }

    public List<T> asList() {
        return this.wrappedStream.collect(Collectors.toList());
    }

    public S filter(Predicate<? super T> predicate) {
        return this.supply(this.wrappedStream.filter(predicate));
    }

    @Override
    public <R> Stream<R> map(Function<? super T, ? extends R> mapper) {
        return this.wrappedStream.map(mapper);
    }

    @Override
    public IntStream mapToInt(ToIntFunction<? super T> mapper) {
        return this.wrappedStream.mapToInt(mapper);
    }

    @Override
    public LongStream mapToLong(ToLongFunction<? super T> mapper) {
        return this.wrappedStream.mapToLong(mapper);
    }

    @Override
    public DoubleStream mapToDouble(ToDoubleFunction<? super T> mapper) {
        return this.wrappedStream.mapToDouble(mapper);
    }

    @Override
    public <R> Stream<R> flatMap(Function<? super T, ? extends Stream<? extends R>> mapper) {
        return this.wrappedStream.flatMap(mapper);
    }

    @Override
    public IntStream flatMapToInt(Function<? super T, ? extends IntStream> mapper) {
        return this.wrappedStream.flatMapToInt(mapper);
    }

    @Override
    public LongStream flatMapToLong(Function<? super T, ? extends LongStream> mapper) {
        return this.wrappedStream.flatMapToLong(mapper);
    }

    @Override
    public DoubleStream flatMapToDouble(Function<? super T, ? extends DoubleStream> mapper) {
        return this.wrappedStream.flatMapToDouble(mapper);
    }

    public S distinct() {
        return this.supply(this.wrappedStream.distinct());
    }

    public S sorted() {
        return this.supply(this.wrappedStream.sorted());
    }

    public S sorted(Comparator<? super T> comparator) {
        return this.supply(this.wrappedStream.sorted(comparator));
    }

    public S peek(Consumer<? super T> consumer) {
        return this.supply(this.wrappedStream.peek(consumer));
    }

    public S limit(long l) {
        return this.supply(this.wrappedStream.limit(l));
    }

    public S skip(long l) {
        return this.supply(this.wrappedStream.skip(l));
    }

    @Override
    public void forEach(Consumer<? super T> action) {
        this.wrappedStream.forEach(action);
    }

    @Override
    public void forEachOrdered(Consumer<? super T> action) {
        this.wrappedStream.forEachOrdered(action);
    }

    @Override
    public Object[] toArray() {
        return this.wrappedStream.toArray();
    }

    @Override
    public <A> A[] toArray(IntFunction<A[]> generator) {
        return this.wrappedStream.toArray(generator);
    }

    @Override
    public T reduce(T identity, BinaryOperator<T> accumulator) {
        return this.wrappedStream.reduce(identity, accumulator);
    }

    @Override
    public Optional<T> reduce(BinaryOperator<T> accumulator) {
        return this.wrappedStream.reduce(accumulator);
    }

    @Override
    public <U> U reduce(U identity, BiFunction<U, ? super T, U> accumulator, BinaryOperator<U> combiner) {
        return this.wrappedStream.reduce(identity, accumulator, combiner);
    }

    @Override
    public <R> R collect(Supplier<R> supplier, BiConsumer<R, ? super T> accumulator, BiConsumer<R, R> combiner) {
        return this.wrappedStream.collect(supplier, accumulator, combiner);
    }

    @Override
    public <R, A> R collect(Collector<? super T, A, R> collector) {
        return this.wrappedStream.collect(collector);
    }

    @Override
    public Optional<T> min(Comparator<? super T> comparator) {
        return this.wrappedStream.min(comparator);
    }

    @Override
    public Optional<T> max(Comparator<? super T> comparator) {
        return this.wrappedStream.max(comparator);
    }

    @Override
    public long count() {
        return this.wrappedStream.count();
    }

    @Override
    public boolean anyMatch(Predicate<? super T> predicate) {
        return this.wrappedStream.anyMatch(predicate);
    }

    @Override
    public boolean allMatch(Predicate<? super T> predicate) {
        return this.wrappedStream.allMatch(predicate);
    }

    @Override
    public boolean noneMatch(Predicate<? super T> predicate) {
        return this.wrappedStream.noneMatch(predicate);
    }

    @Override
    public Optional<T> findFirst() {
        return this.wrappedStream.findFirst();
    }

    @Override
    public Optional<T> findAny() {
        return this.wrappedStream.findAny();
    }

    @Override
    public Iterator<T> iterator() {
        return this.wrappedStream.iterator();
    }

    @Override
    public Spliterator<T> spliterator() {
        return this.wrappedStream.spliterator();
    }

    @Override
    public boolean isParallel() {
        return this.wrappedStream.isParallel();
    }

    @Override
    public S sequential() {
        return this.supply((Stream)this.wrappedStream.sequential());
    }

    @Override
    public S parallel() {
        return this.supply((Stream)this.wrappedStream.parallel());
    }

    @Override
    public S unordered() {
        return this.supply((Stream)this.wrappedStream.unordered());
    }

    @Override
    public S onClose(Runnable runnable) {
        return this.supply((Stream)this.wrappedStream.onClose(runnable));
    }

    @Override
    public void close() {
        this.wrappedStream.close();
    }
}

