/*
 * Decompiled with CFR 0.152.
 */
package com.mzt.logapi.service.impl;

import com.google.common.collect.Maps;
import com.mzt.logapi.service.IParseFunction;
import java.util.List;
import java.util.Map;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class ParseFunctionFactory {
    private Map<String, IParseFunction> functionMap = Maps.newHashMap();

    public ParseFunctionFactory(List<IParseFunction> parseFunctions) {
        if (CollectionUtils.isEmpty(parseFunctions)) {
            return;
        }
        for (IParseFunction parseFunction : parseFunctions) {
            if (StringUtils.isEmpty((Object)parseFunction.functionName())) continue;
            this.functionMap.put(parseFunction.functionName(), parseFunction);
        }
    }

    public IParseFunction getFunction(String functionName) {
        return this.functionMap.get(functionName);
    }
}

