/*
 * Decompiled with CFR 0.152.
 */
package com.mzt.logapi.starter.support.aop;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.mzt.logapi.beans.LogRecord;
import com.mzt.logapi.beans.LogRecordOps;
import com.mzt.logapi.service.ILogRecordService;
import com.mzt.logapi.service.IOperatorGetService;
import com.mzt.logapi.starter.support.aop.LogRecordOperationSource;
import com.mzt.logapi.starter.support.parse.LogRecordValueParser;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class LogRecordInterceptor
extends LogRecordValueParser
implements InitializingBean,
MethodInterceptor,
Serializable {
    private static final Logger log = LoggerFactory.getLogger(LogRecordInterceptor.class);
    private LogRecordOperationSource logRecordOperationSource;
    private String tenantId;
    private ILogRecordService bizLogService;
    private IOperatorGetService operatorGetService;

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Method method = invocation.getMethod();
        return this.execute(invocation, invocation.getThis(), method, invocation.getArguments());
    }

    private Object execute(MethodInvocation invoker, Object target, Method method, Object[] args) throws Throwable {
        Class<?> targetClass = this.getTargetClass(target);
        Object ret = null;
        boolean success = true;
        String errorMsg = "";
        Exception throwable = null;
        try {
            ret = invoker.proceed();
        }
        catch (Exception e) {
            success = false;
            errorMsg = e.getMessage();
            throwable = e;
        }
        try {
            Collection<LogRecordOps> operations = this.getLogRecordOperationSource().computeLogRecordOperations(method, targetClass);
            if (!CollectionUtils.isEmpty(operations)) {
                this.recordExecute(ret, method, args, operations, targetClass, success, errorMsg);
            }
        }
        catch (Exception t) {
            log.error("log record parse exception", (Throwable)t);
        }
        if (throwable != null) {
            throw throwable;
        }
        return ret;
    }

    private void recordExecute(Object ret, Method method, Object[] args, Collection<LogRecordOps> operations, Class<?> targetClass, boolean success, String errorMsg) {
        for (LogRecordOps operation : operations) {
            try {
                ArrayList spElTemplates;
                String action = "";
                if (success) {
                    action = operation.getSuccessLogTemplate();
                } else {
                    action = operation.getFailLogTemplate();
                    if (StringUtils.isEmpty((Object)action)) continue;
                }
                String bizKey = operation.getBizKey();
                String bizNo = operation.getBizNo();
                String operatorId = operation.getOperatorId();
                String category = operation.getCategory();
                String detail = operation.getDetail();
                String realOperator = "";
                if (StringUtils.isEmpty((Object)operatorId)) {
                    spElTemplates = Lists.newArrayList((Object[])new String[]{bizKey, bizNo, action, detail});
                    if (this.operatorGetService.getUser() == null || StringUtils.isEmpty((Object)this.operatorGetService.getUser().getOperatorId())) {
                        throw new IllegalArgumentException("user is null");
                    }
                    realOperator = this.operatorGetService.getUser().getOperatorId();
                } else {
                    spElTemplates = Lists.newArrayList((Object[])new String[]{bizKey, bizNo, action, operatorId, detail});
                }
                Map<String, String> expressionValues = this.processTemplate(spElTemplates, ret, targetClass, method, args, errorMsg);
                LogRecord logRecord = LogRecord.builder().tenant(this.tenantId).bizKey(expressionValues.get(bizKey)).bizNo(expressionValues.get(bizNo)).operator(!StringUtils.isEmpty((Object)realOperator) ? realOperator : expressionValues.get(operatorId)).category(category).detail(expressionValues.get(detail)).action(expressionValues.get(action)).createTime(new Date()).build();
                Preconditions.checkNotNull((Object)this.bizLogService, (Object)"bizLogService not init!!");
                this.bizLogService.record(logRecord);
            }
            catch (Exception t) {
                log.error("log record execute exception", (Throwable)t);
            }
        }
    }

    private Class<?> getTargetClass(Object target) {
        return AopProxyUtils.ultimateTargetClass((Object)target);
    }

    public LogRecordOperationSource getLogRecordOperationSource() {
        return this.logRecordOperationSource;
    }

    public void setLogRecordOperationSource(LogRecordOperationSource logRecordOperationSource) {
        this.logRecordOperationSource = logRecordOperationSource;
    }

    public void setTenant(String tenant) {
        this.tenantId = tenant;
    }

    public void setLogRecordService(ILogRecordService bizLogService) {
        this.bizLogService = bizLogService;
    }

    public void afterPropertiesSet() throws Exception {
        this.bizLogService = (ILogRecordService)this.beanFactory.getBean(ILogRecordService.class);
        this.operatorGetService = (IOperatorGetService)this.beanFactory.getBean(IOperatorGetService.class);
        Preconditions.checkNotNull((Object)this.bizLogService, (Object)"bizLogService not null");
    }

    public void setOperatorGetService(IOperatorGetService operatorGetService) {
        this.operatorGetService = operatorGetService;
    }
}

