/*
 * Decompiled with CFR 0.152.
 */
package com.mzt.logapi.starter.support.parse;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.mzt.logapi.service.IFunctionService;
import com.mzt.logapi.starter.support.parse.LogRecordExpressionEvaluator;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.context.expression.AnnotatedElementKey;
import org.springframework.expression.EvaluationContext;

public class LogRecordValueParser
implements BeanFactoryAware {
    protected BeanFactory beanFactory;
    private LogRecordExpressionEvaluator expressionEvaluator = new LogRecordExpressionEvaluator();
    private IFunctionService functionService;
    private static Pattern pattern = Pattern.compile("\\{\\s*(\\w*)\\s*\\{(.*?)}}");

    public Map<String, String> processTemplate(Collection<String> templates, Object ret, Class<?> targetClass, Method method, Object[] args, String errorMsg) {
        HashMap expressionValues = Maps.newHashMap();
        EvaluationContext evaluationContext = this.expressionEvaluator.createEvaluationContext(method, args, targetClass, ret, errorMsg, this.beanFactory);
        for (String expressionTemplate : templates) {
            if (expressionTemplate.contains("{{") || expressionTemplate.contains("{")) {
                Matcher matcher = pattern.matcher(expressionTemplate);
                StringBuffer parsedStr = new StringBuffer();
                while (matcher.find()) {
                    String expression = matcher.group(2);
                    AnnotatedElementKey annotatedElementKey = new AnnotatedElementKey((AnnotatedElement)method, targetClass);
                    String value = this.expressionEvaluator.parseExpression(expression, annotatedElementKey, evaluationContext);
                    String functionName = matcher.group(1);
                    matcher.appendReplacement(parsedStr, Strings.nullToEmpty((String)this.functionService.apply(functionName, value)));
                }
                matcher.appendTail(parsedStr);
                expressionValues.put(expressionTemplate, parsedStr.toString());
                continue;
            }
            expressionValues.put(expressionTemplate, expressionTemplate);
        }
        return expressionValues;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public void setFunctionService(IFunctionService functionService) {
        this.functionService = functionService;
    }
}

