/*
 * Decompiled with CFR 0.152.
 */
package io.github.talelin.autoconfigure.configuration;

import io.github.talelin.autoconfigure.configuration.LinCmsProperties;
import io.github.talelin.autoconfigure.interceptor.AuthorizeInterceptor;
import io.github.talelin.autoconfigure.interceptor.LogInterceptor;
import io.github.talelin.core.token.DoubleJWT;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;

@Configuration(proxyBeanMethods=false)
@Order(value=-2147483648)
@EnableConfigurationProperties(value={LinCmsProperties.class})
public class LinCmsConfiguration {
    @Autowired
    private LinCmsProperties properties;

    @Bean
    public DoubleJWT jwter() {
        String secret = this.properties.getTokenSecret();
        Long accessExpire = this.properties.getTokenAccessExpire();
        Long refreshExpire = this.properties.getTokenRefreshExpire();
        if (accessExpire == null) {
            accessExpire = 3600L;
        }
        if (refreshExpire == null) {
            refreshExpire = 2592000L;
        }
        return new DoubleJWT(secret, accessExpire.longValue(), refreshExpire.longValue());
    }

    @Bean
    public AuthorizeInterceptor authInterceptor() {
        String[] excludeMethods = this.properties.getExcludeMethods();
        return new AuthorizeInterceptor(excludeMethods);
    }

    @Bean
    @ConditionalOnProperty(prefix="lin.cms", value={"logger-enabled"}, havingValue="true")
    public LogInterceptor logInterceptor() {
        return new LogInterceptor();
    }
}

