/*
 * Decompiled with CFR 0.152.
 */
package io.github.talelin.autoconfigure.validator.impl;

import io.github.talelin.autoconfigure.validator.EnumValue;
import java.lang.reflect.Method;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnumValueValidator
implements ConstraintValidator<EnumValue, Object> {
    private static final Logger log = LoggerFactory.getLogger(EnumValueValidator.class);
    private Class<?> cls;

    public void initialize(EnumValue constraintAnnotation) {
        this.cls = constraintAnnotation.target();
    }

    public boolean isValid(Object value, ConstraintValidatorContext context) {
        if (value == null) {
            return true;
        }
        try {
            ?[] objs = this.cls.getEnumConstants();
            Method method = this.cls.getMethod("getValue", new Class[0]);
            for (Object obj : objs) {
                Object val = method.invoke(obj, new Object[0]);
                if (!val.equals(value)) continue;
                return true;
            }
            return false;
        }
        catch (Exception e) {
            log.warn("EnumValue \u6821\u9a8c\u5f02\u5e38", (Throwable)e);
            return false;
        }
    }
}

