/*
 * Decompiled with CFR 0.152.
 */
package com.sophon.component.exception;

import com.sophon.component.SophonInit;
import com.sophon.logger.source.ExceptionLogger;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;

public class UncheckedExceptionHandler
implements Thread.UncaughtExceptionHandler,
SophonInit {
    private ThreadGroup currentGroup;
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        String className = "--- ".concat(e.getStackTrace()[0].getClassName()).concat(": ").concat(e.getStackTrace()[0].getMethodName()).concat(" ---");
        String datetime = "--- ".concat(sdf.format(new Date())).concat(" ---");
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        String exceptionInfo = sw.toString();
        StringBuffer buffer = new StringBuffer();
        buffer.append(className).append("\n").append(datetime).append("\n\n     ").append(exceptionInfo);
        String endExceptionInfo = "\n".concat(buffer.toString()).concat("\n");
        ExceptionLogger.exception(endExceptionInfo);
    }

    @Override
    public void init() {
        this.currentGroup = Thread.currentThread().getThreadGroup();
        int activeCount = this.currentGroup.activeCount();
        Thread[] group = new Thread[activeCount];
        this.currentGroup.enumerate(group);
        for (Thread thread : group) {
            thread.setUncaughtExceptionHandler(new UncheckedExceptionHandler());
        }
    }
}

