/*
 * Decompiled with CFR 0.152.
 */
package com.sophon.component.io;

import com.sophon.config.Slog4jConfiguration;
import com.sophon.util.StringUtils;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;

public class SophonFile
extends File {
    public SophonFile(String pathname, boolean isCreate) {
        super(pathname);
    }

    public SophonFile(String pathname) {
        super(pathname);
        if (!this.exists() && Slog4jConfiguration.getInstance().getLoggerPrintWrite()) {
            this.create();
        }
    }

    public SophonFile(String parent, String child) {
        super(parent, child);
    }

    public SophonFile(File parent, String child) {
        super(parent, child);
    }

    public SophonFile(URI uri) {
        super(uri);
    }

    public String getSuffix() {
        String suffix = this.getName();
        return suffix.substring(suffix.lastIndexOf("."));
    }

    public long getSizeByKB() {
        return this.length() / 1024L;
    }

    public boolean create() {
        return this.create(this.getName());
    }

    public boolean create(String filename) {
        File file = new File(this.getParent(), filename);
        try {
            if (!file.getParentFile().exists()) {
                new File(file.getParent()).mkdirs();
            }
            return file.createNewFile();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public ArrayList<String> getFileNamesByFolderNoSuffix() {
        File[] files;
        ArrayList<String> names = new ArrayList<String>();
        for (File file : files = this.getParentFile().listFiles()) {
            String name = file.getName();
            names.add(name.substring(0, name.lastIndexOf(".")));
        }
        return names;
    }

    public ArrayList<String> getFileNamesByFolder() {
        File[] files;
        ArrayList<String> names = new ArrayList<String>();
        for (File file : files = this.getParentFile().listFiles()) {
            String name = file.getName();
            names.add(name);
        }
        return names;
    }

    public String getNoSuffixName() {
        String name = this.getName();
        return name.substring(0, name.lastIndexOf("."));
    }

    public String getNewFileName() {
        String name = this.getName();
        String var1 = name.substring(0, name.lastIndexOf("_") + 1);
        String var2 = name.substring(name.lastIndexOf("."));
        return var1 + this.getNewestFileIndex() + var2;
    }

    public int getNewestFileIndex() {
        int index = 0;
        ArrayList<Integer> indexs = new ArrayList<Integer>();
        String currentName = this.getNoSuffixName().substring(0, this.getNoSuffixName().lastIndexOf("_"));
        for (String filename : this.getFileNamesByFolderNoSuffix()) {
            String indexstr;
            String filenameNoIndex = filename.substring(0, filename.lastIndexOf("_"));
            if (!filenameNoIndex.equals(currentName) || !StringUtils.isNumber(indexstr = filename.substring(filename.lastIndexOf("_") + 1))) continue;
            indexs.add(Integer.parseInt(indexstr));
        }
        if (!indexs.isEmpty() && indexs.size() >= 1) {
            Collections.sort(indexs, Collections.reverseOrder());
            return (Integer)indexs.get(0) + 1;
        }
        return index;
    }

    public SophonFile getNewFileObject() {
        return new SophonFile(this.getParent().concat("/").concat(this.getNewFileName()));
    }

    public static SophonFile getFile(String pathname) {
        String classpath = "classpath:";
        if (classpath.equals(pathname.substring(0, classpath.length()))) {
            pathname = pathname.replaceAll(classpath, "");
            pathname = System.getProperty("user.dir").concat(pathname);
            pathname = pathname.replaceAll("/", "\\\\");
        }
        SophonFile file = new SophonFile(pathname, false);
        return new SophonFile(file.getParent().concat("/").concat(file.getNoSuffixName()).concat("_0").concat(file.getSuffix()));
    }
}

