/*
 * Decompiled with CFR 0.152.
 */
package com.sophon.config;

import com.sophon.component.Entrance;
import com.sophon.logger.SophonLogger;
import com.sophon.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Slog4jConfiguration {
    public static final String pathPrefix = "classpath:";
    private static Slog4jConfiguration cv;
    private static Properties config;
    private long writeCount = 0L;
    private long printCount = 0L;
    private final String LOGGER_PRINT_PATH = this.getValue("logger.print.path");
    private final String LOGGER_SYSTEM_PRINT_PATH = this.getValue("logger.system.print.path");
    private final String LOGGER_SYSTEM_PRINT_CAPTURE_EXCEPTION_PATH = this.getValue("logger.system.print.capture.exception.path");
    private final String LOGGER_PRINT_TEMPLATE = this.getValue("logger.print.template");
    public final String BY_SIZE = "size";
    private final String LOGGER_GENERATE_RULE = this.getValue("logger.generate.rule");
    private final String LOGGER_PROHIBIT_LEVEL_CONSOLE = this.getValue("logger.prohibit.level.console");
    private final String LOGGER_PROHIBIT_LEVEL_FILE = this.getValue("logger.prohibit.level.file");
    private final String SLOG4j_SYSTEM_PROMPT_LANGUAGE = this.getValue("slog4j.system.prompt.language");
    private final String LOGGER_PRINT_WRITE = this.getValue("logger.print.write");

    private Slog4jConfiguration() {
    }

    public static void loadProperties(String pathname) {
        try {
            String classpath = pathPrefix;
            if (classpath.equals(pathname.substring(0, classpath.length()))) {
                pathname = pathname.replaceAll(classpath, "");
                pathname = System.getProperty("user.dir").concat(pathname);
                pathname = pathname.replaceAll("/", "\\\\");
            }
            config = new Properties();
            FileInputStream stream = new FileInputStream(pathname);
            config.load(stream);
            ((InputStream)stream).close();
            Entrance.frameworkInit();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static Slog4jConfiguration getInstance() {
        if (cv == null) {
            if (config == null) {
                try {
                    config = new Properties();
                    String path = System.getProperty("user.dir") + "\\src\\main\\resources\\slog4j.properties";
                    if (!(new File(path).exists() || new File(path).exists() || new File(path = System.getProperty("user.dir") + "\\resources\\slog4j.properties").exists())) {
                        throw new NullPointerException("\u5982\u679c\u8981\u4f7f\u7528\u81ea\u52a8\u626b\u63cf\u914d\u7f6e\u6587\u4ef6\u529f\u80fd,\u8bf7\u5c06\u6587\u4ef6\u653e\u5728resources\u76ee\u5f55\u4e0b");
                    }
                    FileInputStream is = new FileInputStream(path);
                    config.load(is);
                    ((InputStream)is).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            cv = new Slog4jConfiguration();
            Entrance.frameworkInit();
        }
        return cv;
    }

    private String getValue(String key) {
        String v = null;
        try {
            v = new String(config.getProperty(key).getBytes("ISO-8859-1"), "GBK");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return v;
    }

    public void writePlus() {
        ++this.writeCount;
    }

    public void printPlus() {
        ++this.printCount;
    }

    public long getWriteCount() {
        return this.writeCount;
    }

    public long getPrintCount() {
        return this.printCount;
    }

    public SimpleDateFormat getSimpleDateFormat() {
        String v = this.LOGGER_PRINT_TEMPLATE;
        if (StringUtils.isExist(v, "\\$\\{datetime:(.*?)\\}")) {
            Pattern pattern = Pattern.compile("\\$\\{(.*?)\\}");
            Matcher matcher = pattern.matcher(v);
            matcher.find();
            String datetime = matcher.group(1).replaceAll("datetime:", "");
            return new SimpleDateFormat(datetime);
        }
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    }

    public String getLoggerPrintTemplate() {
        String v = this.LOGGER_PRINT_TEMPLATE;
        v = v.replaceAll("\\$\\{datetime:(.*?)\\}", "\\$\\{datetime\\}");
        return v;
    }

    public String getLoggerPrintPath() {
        return this.LOGGER_PRINT_PATH;
    }

    public String[] getLoggerGenerateRule() {
        String[] v = new String[2];
        String rule = this.LOGGER_GENERATE_RULE;
        return rule.split(":");
    }

    public String getSlog4jSystemPromptLanguage() {
        return System.getProperty("user.dir").concat("\\language\\").concat(this.SLOG4j_SYSTEM_PROMPT_LANGUAGE);
    }

    public boolean getLoggerPrintWrite() {
        switch (this.LOGGER_PRINT_WRITE) {
            case "true": {
                return true;
            }
            case "false": {
                return false;
            }
        }
        return true;
    }

    public String getLoggerSystemPrintCaptureExceptionPath() {
        return this.LOGGER_SYSTEM_PRINT_CAPTURE_EXCEPTION_PATH;
    }

    public String getLoggerSystemPrintPath() {
        return this.LOGGER_SYSTEM_PRINT_PATH;
    }

    public Set<SophonLogger.Level> getLoggerProhibitLevelConsole() {
        String[] levels;
        HashSet<SophonLogger.Level> set = new HashSet<SophonLogger.Level>();
        if ("no".equals(this.LOGGER_PROHIBIT_LEVEL_FILE)) {
            return set;
        }
        for (String level : levels = this.LOGGER_PROHIBIT_LEVEL_CONSOLE.split(",")) {
            if (level.equals(SophonLogger.Level.INFO.toString())) {
                set.add(SophonLogger.Level.INFO);
            }
            if (level.equals(SophonLogger.Level.DEBUG.toString())) {
                set.add(SophonLogger.Level.DEBUG);
            }
            if (level.equals(SophonLogger.Level.ERROR.toString())) {
                set.add(SophonLogger.Level.ERROR);
            }
            if (!level.equals(SophonLogger.Level.WARN.toString())) continue;
            set.add(SophonLogger.Level.WARN);
        }
        return set;
    }

    public Set<SophonLogger.Level> getLoggerProhibitLevelFile() {
        String[] levels;
        HashSet<SophonLogger.Level> set = new HashSet<SophonLogger.Level>();
        if ("no".equals(this.LOGGER_PROHIBIT_LEVEL_FILE)) {
            return set;
        }
        for (String level : levels = this.LOGGER_PROHIBIT_LEVEL_FILE.split(",")) {
            if (level.equals(SophonLogger.Level.INFO.toString())) {
                set.add(SophonLogger.Level.INFO);
            }
            if (level.equals(SophonLogger.Level.DEBUG.toString())) {
                set.add(SophonLogger.Level.DEBUG);
            }
            if (level.equals(SophonLogger.Level.ERROR.toString())) {
                set.add(SophonLogger.Level.ERROR);
            }
            if (!level.equals(SophonLogger.Level.WARN.toString())) continue;
            set.add(SophonLogger.Level.WARN);
        }
        return set;
    }

    public void main(String[] args) {
        System.out.println(this.getLoggerPrintTemplate());
    }
}

