/*
 * Decompiled with CFR 0.152.
 */
package com.sophon.logger;

import com.sophon.config.Slog4jConfiguration;
import com.sophon.io.SophonIO;
import com.sophon.io.SophonWrite;
import com.sophon.logger.SophonLogger;
import java.text.DateFormat;
import java.util.Date;
import java.util.Set;

public class SophonLoggerImpl
implements SophonLogger {
    protected int trace = 2;
    private static final String formatString = "\\{\\}";
    protected final Set<SophonLogger.Level> printIgnore = Slog4jConfiguration.getInstance().getLoggerProhibitLevelConsole();
    protected final Set<SophonLogger.Level> writeIgnore = Slog4jConfiguration.getInstance().getLoggerProhibitLevelFile();
    protected final DateFormat sdf = Slog4jConfiguration.getInstance().getSimpleDateFormat();
    protected final String printTemplate = Slog4jConfiguration.getInstance().getLoggerPrintTemplate();
    protected final SophonWrite write = SophonIO.getWrite();

    public SophonLoggerImpl() {
    }

    public SophonLoggerImpl(int trace) {
        this.trace = trace;
    }

    @Override
    public void info(String v) {
        this.console(this.prefixGenerate(SophonLogger.Level.INFO).concat(v), SophonLogger.Level.INFO);
    }

    @Override
    public void info(String v, Object ... args) {
        this.console(this.prefixGenerate(SophonLogger.Level.INFO).concat(SophonLoggerImpl.format(v, args)), SophonLogger.Level.INFO);
    }

    @Override
    public void info(Object v) {
        this.console(this.prefixGenerate(SophonLogger.Level.INFO).concat(String.valueOf(v)), SophonLogger.Level.INFO);
    }

    @Override
    public void info(String v, Thread t) {
        this.console(this.prefixGenerate(SophonLogger.Level.INFO, t).concat(v), SophonLogger.Level.INFO);
    }

    @Override
    public void info(String v, Thread t, Object ... args) {
        this.console(this.prefixGenerate(SophonLogger.Level.INFO, t).concat(SophonLoggerImpl.format(v, args)), SophonLogger.Level.INFO);
    }

    @Override
    public void debug(Object v) {
        this.console(this.prefixGenerate(SophonLogger.Level.DEBUG).concat(String.valueOf(v)), SophonLogger.Level.DEBUG);
    }

    @Override
    public void debug(String v) {
        this.console(this.prefixGenerate(SophonLogger.Level.DEBUG).concat(v), SophonLogger.Level.DEBUG);
    }

    @Override
    public void debug(String v, Object ... args) {
        this.console(this.prefixGenerate(SophonLogger.Level.DEBUG).concat(SophonLoggerImpl.format(v, args)), SophonLogger.Level.DEBUG);
    }

    @Override
    public void debug(String v, Thread t) {
        this.console(this.prefixGenerate(SophonLogger.Level.DEBUG, t).concat(v), SophonLogger.Level.DEBUG);
    }

    @Override
    public void debug(String v, Thread t, Object ... args) {
        this.console(this.prefixGenerate(SophonLogger.Level.DEBUG, t).concat(SophonLoggerImpl.format(v, args)), SophonLogger.Level.DEBUG);
    }

    @Override
    public void error(Object v) {
        this.console(this.prefixGenerate(SophonLogger.Level.ERROR).concat(String.valueOf(v)), SophonLogger.Level.ERROR);
    }

    @Override
    public void error(String v) {
        this.console(this.prefixGenerate(SophonLogger.Level.ERROR).concat(v), SophonLogger.Level.ERROR);
    }

    @Override
    public void error(String v, Object ... args) {
        this.console(this.prefixGenerate(SophonLogger.Level.ERROR).concat(SophonLoggerImpl.format(v, args)), SophonLogger.Level.ERROR);
    }

    @Override
    public void error(String v, Thread t) {
        this.console(this.prefixGenerate(SophonLogger.Level.ERROR, t).concat(v), SophonLogger.Level.ERROR);
    }

    @Override
    public void error(String v, Thread t, Object ... args) {
        this.console(this.prefixGenerate(SophonLogger.Level.ERROR, t).concat(SophonLoggerImpl.format(v, args)), SophonLogger.Level.ERROR);
    }

    @Override
    public void warn(Object v) {
        this.console(this.prefixGenerate(SophonLogger.Level.WARN).concat(String.valueOf(v)), SophonLogger.Level.WARN);
    }

    @Override
    public void warn(String v) {
        this.console(this.prefixGenerate(SophonLogger.Level.WARN).concat(v), SophonLogger.Level.WARN);
    }

    @Override
    public void warn(String v, Object ... args) {
        this.console(this.prefixGenerate(SophonLogger.Level.WARN).concat(SophonLoggerImpl.format(v, args)), SophonLogger.Level.WARN);
    }

    @Override
    public void warn(String v, Thread t) {
        this.console(this.prefixGenerate(SophonLogger.Level.WARN, t).concat(v), SophonLogger.Level.WARN);
    }

    @Override
    public void warn(String v, Thread t, Object ... args) {
        this.console(this.prefixGenerate(SophonLogger.Level.WARN, t).concat(SophonLoggerImpl.format(v, args)), SophonLogger.Level.WARN);
    }

    @Override
    public String prefixGenerate(SophonLogger.Level level) {
        return this.prefixGenerate(level, Thread.currentThread());
    }

    @Override
    public String prefixGenerate(SophonLogger.Level level, Thread t) {
        String className = t.getStackTrace()[this.trace].getClassName();
        String methodName = t.getStackTrace()[this.trace].getMethodName();
        String lineNumber = String.valueOf(t.getStackTrace()[this.trace].getLineNumber());
        String v = this.printTemplate.replace("${line}", lineNumber).replace("${class}", className).replace("${level}", String.valueOf((Object)level)).replace("${method}", methodName).replace("${datetime}", this.sdf.format(new Date()));
        return v;
    }

    protected synchronized void console(String v, SophonLogger.Level level) {
        if (!this.printIgnore.contains((Object)level)) {
            System.out.println(v);
            Slog4jConfiguration.getInstance().printPlus();
            if (Slog4jConfiguration.getInstance().getLoggerPrintWrite() && !this.writeIgnore.contains((Object)level)) {
                this.write.write(v);
            }
        }
    }

    private static String format(String v, Object ... args) {
        v = v.replaceAll(formatString, "%s");
        v = String.format(v, args);
        return v;
    }
}

