/*
 * Decompiled with CFR 0.152.
 */
package com.sophon.logger;

import com.sophon.component.io.SophonFile;
import com.sophon.config.Slog4jConfiguration;
import com.sophon.io.SophonWrite;
import com.sophon.io.SophonWriteBySize;
import com.sophon.logger.SophonLogger;
import com.sophon.logger.SophonLoggerImpl;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public class SystemLoggerImpl
extends SophonLoggerImpl {
    protected int trace = 2;
    private static final String formatString = "\\{\\}";
    protected final DateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    protected SophonWrite write;

    public SystemLoggerImpl() {
    }

    public SystemLoggerImpl(int trace) {
        this.trace = trace;
        this.write = new SophonWriteBySize(2048, SophonFile.getFile(Slog4jConfiguration.getInstance().getLoggerSystemPrintPath()));
    }

    public SystemLoggerImpl(int trace, SophonFile file) {
        this.trace = trace;
        this.write = new SophonWriteBySize(2048, file);
    }

    public void exception(String v) {
        this.console(v, SophonLogger.Level.ERROR);
    }

    @Override
    public String prefixGenerate(SophonLogger.Level level, Thread t) {
        String className = t.getStackTrace()[this.trace].getClassName();
        String methodName = t.getStackTrace()[this.trace].getMethodName();
        String lineNumber = String.valueOf(t.getStackTrace()[this.trace].getLineNumber());
        String v = "${datetime} | ${class} ${method}:${line} | [FRAMEWORK][${level}] - ";
        return v.replaceAll("\\$\\{line\\}", lineNumber).replaceAll("\\$\\{class\\}", className).replaceAll("\\$\\{level\\}", String.valueOf((Object)level)).replaceAll("\\$\\{method\\}", methodName).replaceAll("\\$\\{datetime\\}", this.sdf.format(new Date()));
    }

    @Override
    protected synchronized void console(String v, SophonLogger.Level level) {
        if (level == SophonLogger.Level.ERROR || level == SophonLogger.Level.WARN) {
            System.err.println(v);
        } else {
            System.out.println(v);
        }
        if (Slog4jConfiguration.getInstance().getLoggerPrintWrite()) {
            this.write.write(v);
        }
    }
}

