/*
 * Decompiled with CFR 0.152.
 */
package com.sophon.util;

import com.sophon.component.exception.ParamException;
import com.sophon.component.io.SophonFile;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

public class SophonUtils {
    public static ArrayList<Class<?>> getInterfaceImpls(Class<?> target) {
        ArrayList subclasses;
        block5: {
            subclasses = new ArrayList();
            try {
                if (target.isInterface()) {
                    String basePackage = target.getClassLoader().getResource("").getPath();
                    File[] files = new File(basePackage).listFiles();
                    ArrayList<String> classpaths = new ArrayList<String>();
                    for (File file : files) {
                        if (!file.isDirectory()) continue;
                        SophonUtils.listPackages(file.getName(), classpaths);
                    }
                    for (String classpath : classpaths) {
                        HashSet interfaces;
                        Class<?> classObject = Class.forName(classpath);
                        if (classObject.getSuperclass() == null || !(interfaces = new HashSet(Arrays.asList(classObject.getInterfaces()))).contains(target)) continue;
                        subclasses.add(Class.forName(classObject.getName()));
                    }
                    break block5;
                }
                throw new ParamException("Class\u5bf9\u8c61\u4e0d\u662f\u4e00\u4e2ainterface");
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        return subclasses;
    }

    public static void listPackages(String basePackage, List<String> classes) {
        URL url = SophonUtils.class.getClassLoader().getResource("./" + basePackage.replaceAll("\\.", "/"));
        File directory = new File(url.getFile());
        for (File file : directory.listFiles()) {
            if (file.isDirectory()) {
                SophonUtils.listPackages(basePackage + "." + file.getName(), classes);
                continue;
            }
            String classpath = file.getName();
            if (!".class".equals(classpath.substring(classpath.length() - ".class".length()))) continue;
            classes.add(basePackage + "." + classpath.replaceAll(".class", ""));
        }
    }

    public static BufferedWriter newBufferedWriter(SophonFile file) throws FileNotFoundException {
        return new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file, true)));
    }
}

