/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty;

import com.google.common.base.Preconditions;
import io.grpc.Status;
import io.grpc.netty.ProtocolNegotiationEvent;
import io.grpc.netty.Utils;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.SocketAddress;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;

final class WriteBufferingAndExceptionHandler
extends ChannelDuplexHandler {
    private static final Logger logger = Logger.getLogger(WriteBufferingAndExceptionHandler.class.getName());
    private final Queue<ChannelWrite> bufferedWrites = new ArrayDeque<ChannelWrite>();
    private final ChannelHandler next;
    private boolean writing;
    private boolean flushRequested;
    private Throwable failCause;

    WriteBufferingAndExceptionHandler(ChannelHandler next) {
        this.next = (ChannelHandler)Preconditions.checkNotNull((Object)next, (Object)"next");
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        ctx.pipeline().addBefore(ctx.name(), null, this.next);
        super.handlerAdded(ctx);
        ctx.pipeline().fireUserEventTriggered((Object)ProtocolNegotiationEvent.DEFAULT);
    }

    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        if (!this.bufferedWrites.isEmpty()) {
            Status status = Status.INTERNAL.withDescription("Buffer removed before draining writes");
            this.failWrites((Throwable)status.asRuntimeException());
        }
        super.handlerRemoved(ctx);
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        Status status = Status.UNAVAILABLE.withDescription("Connection closed while performing protocol negotiation for " + ctx.pipeline().names());
        this.failWrites((Throwable)status.asRuntimeException());
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        assert (cause != null);
        Throwable previousFailure = this.failCause;
        Status status = Utils.statusFromThrowable(cause);
        this.failWrites((Throwable)status.asRuntimeException());
        if (ctx.channel().isActive() && previousFailure == null) {
            ctx.close();
        }
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        if (this.failCause != null) {
            promise.setFailure(this.failCause);
            ReferenceCountUtil.release((Object)msg);
        } else {
            this.bufferedWrites.add(new ChannelWrite(msg, promise));
        }
    }

    public void connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) throws Exception {
        super.connect(ctx, remoteAddress, localAddress, promise);
        final class ConnectListener
        implements ChannelFutureListener {
            ConnectListener() {
            }

            public void operationComplete(ChannelFuture future) {
                if (!future.isSuccess()) {
                    WriteBufferingAndExceptionHandler.this.failWrites(future.cause());
                }
            }
        }
        promise.addListener((GenericFutureListener)new ConnectListener());
    }

    public void flush(ChannelHandlerContext ctx) {
        this.flushRequested = true;
    }

    public void close(ChannelHandlerContext ctx, ChannelPromise future) throws Exception {
        Status status = Status.UNAVAILABLE.withDescription("Connection closing while performing protocol negotiation for " + ctx.pipeline().names());
        this.failWrites((Throwable)status.asRuntimeException());
        super.close(ctx, future);
    }

    final void writeBufferedAndRemove(ChannelHandlerContext ctx) {
        if (!ctx.channel().isActive() || this.writing) {
            return;
        }
        this.writing = true;
        while (!this.bufferedWrites.isEmpty()) {
            ChannelWrite write = this.bufferedWrites.poll();
            ctx.write(write.msg, write.promise);
        }
        if (this.flushRequested) {
            ctx.flush();
        }
        ctx.pipeline().remove((ChannelHandler)this);
    }

    private void failWrites(Throwable cause) {
        if (this.failCause == null) {
            this.failCause = cause;
        } else {
            logger.log(Level.FINE, "Ignoring duplicate failure", cause);
        }
        while (!this.bufferedWrites.isEmpty()) {
            ChannelWrite write = this.bufferedWrites.poll();
            write.promise.setFailure(cause);
            ReferenceCountUtil.release((Object)write.msg);
        }
    }

    private static final class ChannelWrite {
        final Object msg;
        final ChannelPromise promise;

        ChannelWrite(Object msg, ChannelPromise promise) {
            this.msg = msg;
            this.promise = promise;
        }
    }
}

