/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.security.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.authentication.AuthenticationData;
import com.ibm.ws.security.authentication.AuthenticationException;
import com.ibm.ws.security.authentication.AuthenticationService;
import com.ibm.ws.security.authentication.WSAuthenticationData;
import com.ibm.ws.webcontainer.security.AuthResult;
import com.ibm.ws.webcontainer.security.AuthenticationResult;
import com.ibm.ws.webcontainer.security.SSOCookieHelper;
import com.ibm.ws.webcontainer.security.WebAuthenticator;
import com.ibm.ws.webcontainer.security.WebRequest;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import javax.security.auth.Subject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class CertificateLoginAuthenticator
implements WebAuthenticator {
    private static final TraceComponent tc = Tr.register(CertificateLoginAuthenticator.class, (String)"WebAppSecurity", (String)"com.ibm.ws.webcontainer.security.resources.WebAppSecurityMessages");
    private AuthenticationService authenticationService = null;
    private SSOCookieHelper ssoCookieHelper = null;
    public static final String PEER_CERTIFICATES = "javax.net.ssl.peer_certificates";
    static final long serialVersionUID = -2325844543998989967L;

    public CertificateLoginAuthenticator(AuthenticationService authnServ, SSOCookieHelper ssoCookieHelper) {
        this.authenticationService = authnServ;
        this.ssoCookieHelper = ssoCookieHelper;
    }

    @Override
    public AuthenticationResult authenticate(WebRequest webRequest) {
        HttpServletRequest req = webRequest.getHttpServletRequest();
        HttpServletResponse res = webRequest.getHttpServletResponse();
        return this.authenticate(req, res, (HashMap)null);
    }

    @FFDCIgnore(value={AuthenticationException.class})
    public AuthenticationResult authenticate(HttpServletRequest req, HttpServletResponse res, HashMap props) {
        AuthenticationResult authResult = null;
        X509Certificate[] certChain = (X509Certificate[])req.getAttribute(PEER_CERTIFICATES);
        if (certChain == null || certChain.length == 0) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"The CLIENT-CERT authentication failed because no client certificate was found.", (Object[])new Object[0]);
            }
            authResult = new AuthenticationResult(AuthResult.FAILURE, "The CLIENT-CERT authentication failed because no client certificate was found.");
            authResult.setAuditCredType("CLIENT-CERT");
            authResult.setAuditCredValue("UNAUTHORIZED");
            authResult.setAuditOutcome("failure");
            return authResult;
        }
        try {
            String thisAuthMech = "system.WEB_INBOUND";
            WSAuthenticationData authenticationData = new WSAuthenticationData();
            authenticationData.set("HTTP_SERVLET_REQUEST", (Object)req);
            authenticationData.set("HTTP_SERVLET_RESPONSE", (Object)res);
            authenticationData.set("CERTCHAIN", (Object)certChain);
            Subject authenticatedSubject = this.authenticationService.authenticate(thisAuthMech, (AuthenticationData)authenticationData, null);
            String certDN = certChain[0].getSubjectX500Principal().getName();
            authResult = new AuthenticationResult(AuthResult.SUCCESS, authenticatedSubject, "CLIENT-CERT", certDN, "success");
        }
        catch (AuthenticationException e) {
            String certDN = certChain[0].getSubjectX500Principal().getName();
            authResult = new AuthenticationResult(AuthResult.FAILURE, e.getMessage(), "CLIENT-CERT", certDN, "denied");
        }
        authResult.certdn = certChain[0].getSubjectX500Principal().getName();
        if (authResult.getStatus() == AuthResult.SUCCESS) {
            this.ssoCookieHelper.addSSOCookiesToResponse(authResult.getSubject(), req, res);
        }
        return authResult;
    }
}

