/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.security.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.authentication.AuthenticationData;
import com.ibm.ws.security.authentication.AuthenticationException;
import com.ibm.ws.security.authentication.AuthenticationService;
import com.ibm.ws.security.authentication.WSAuthenticationData;
import com.ibm.ws.security.jwtsso.token.proxy.JwtSSOTokenHelper;
import com.ibm.ws.webcontainer.security.AuthResult;
import com.ibm.ws.webcontainer.security.AuthenticateApi;
import com.ibm.ws.webcontainer.security.AuthenticationResult;
import com.ibm.ws.webcontainer.security.CookieHelper;
import com.ibm.ws.webcontainer.security.LoggedOutTokenCacheImpl;
import com.ibm.ws.webcontainer.security.SSOCookieHelper;
import com.ibm.ws.webcontainer.security.WebAppSecurityConfig;
import com.ibm.ws.webcontainer.security.WebAuthenticator;
import com.ibm.ws.webcontainer.security.WebRequest;
import com.ibm.ws.webcontainer.security.internal.LoggedOutJwtSsoCookieCache;
import com.ibm.ws.webcontainer.security.metadata.LoginConfiguration;
import com.ibm.ws.webcontainer.security.metadata.SecurityMetadata;
import com.ibm.ws.webcontainer.security.util.SSOAuthFilter;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import java.util.HashMap;
import javax.security.auth.Subject;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class SSOAuthenticator
implements WebAuthenticator {
    public static final String DEFAULT_SSO_COOKIE_NAME = "LtpaToken2";
    private static final String Authorization_Header = "Authorization";
    public static final String REQ_METHOD_POST = "POST";
    public static final String REQ_CONTENT_TYPE_NAME = "Content-Type";
    public static final String REQ_CONTENT_TYPE_APP_FORM_URLENCODED = "application/x-www-form-urlencoded";
    private static final String ACCESS_TOKEN = "access_token";
    private static final String LTPA_OID = "oid:1.3.18.0.2.30.2";
    private static final String JWT_OID = "oid:1.3.18.0.2.30.3";
    private static final TraceComponent tc = Tr.register(SSOAuthenticator.class, (String)"WebAppSecurity", (String)"com.ibm.ws.webcontainer.security.resources.WebAppSecurityMessages");
    private final AuthenticationService authenticationService;
    private final WebAppSecurityConfig webAppSecurityConfig;
    private final SSOCookieHelper ssoCookieHelper;
    private final String challengeType;
    private final AtomicServiceReference<SSOAuthFilter> ssoAuthFilterRef;
    static final long serialVersionUID = 2525470211590876734L;

    public SSOAuthenticator(AuthenticationService authenticationService, SecurityMetadata securityMetadata, WebAppSecurityConfig webAppSecurityConfig, SSOCookieHelper ssoCookieHelper, AtomicServiceReference<SSOAuthFilter> ssoAuthFilterRef) {
        this.authenticationService = authenticationService;
        this.webAppSecurityConfig = webAppSecurityConfig;
        this.ssoCookieHelper = ssoCookieHelper;
        this.ssoAuthFilterRef = ssoAuthFilterRef;
        LoginConfiguration loginConfig = securityMetadata == null ? null : securityMetadata.getLoginConfiguration();
        this.challengeType = loginConfig == null ? null : loginConfig.getAuthenticationMethod();
    }

    @Override
    public AuthenticationResult authenticate(WebRequest webRequest) {
        return this.authenticate(webRequest, this.webAppSecurityConfig);
    }

    public AuthenticationResult authenticate(WebRequest webRequest, WebAppSecurityConfig webAppSecConfig) {
        HttpServletResponse res;
        HttpServletRequest req = webRequest.getHttpServletRequest();
        AuthenticationResult authResult = this.handleSSO(req, res = webRequest.getHttpServletResponse());
        if (authResult != null && authResult.getStatus() == AuthResult.SUCCESS) {
            this.ssoCookieHelper.addJwtSsoCookiesToResponse(authResult.getSubject(), req, res);
        }
        return authResult;
    }

    public AuthenticationResult handleSSO(HttpServletRequest req, HttpServletResponse res) {
        boolean comp;
        AuthenticationResult authResult = null;
        Cookie[] cookies = req.getCookies();
        if (cookies == null) {
            return authResult;
        }
        boolean bl = comp = this.webAppSecurityConfig != null && this.webAppSecurityConfig.getLogoutOnHttpSessionExpire();
        if (comp && req.getRequestedSessionId() != null && !req.isRequestedSessionIdValid() && this.challengeType != null && this.challengeType.equals("FORM")) {
            this.ssoCookieHelper.createLogoutCookies(req, res);
            return authResult;
        }
        if (this.isJwtAuthFilterAccept(req) && (authResult = this.handleJwtSSO(req, res)) != null && authResult.getStatus() == AuthResult.SUCCESS) {
            return authResult;
        }
        if (authResult != null || !JwtSSOTokenHelper.shouldUseLtpaIfJwtAbsent()) {
            return authResult;
        }
        if (this.isLtpaAuthFilterAccept(req) && (authResult = this.handleLtpaSSO(req, res, cookies)) != null && authResult.getStatus() == AuthResult.SUCCESS) {
            return authResult;
        }
        this.ssoCookieHelper.createLogoutCookies(req, res);
        return authResult;
    }

    @FFDCIgnore(value={AuthenticationException.class})
    private AuthenticationResult handleLtpaSSO(HttpServletRequest req, HttpServletResponse res, Cookie[] cookies) {
        boolean useOnlyCustomCookieName;
        AuthenticationResult authResult = null;
        String cookieName = this.ssoCookieHelper.getSSOCookiename();
        String[] hdrVals = CookieHelper.getCookieValues(cookies, cookieName);
        boolean bl = useOnlyCustomCookieName = this.webAppSecurityConfig != null && this.webAppSecurityConfig.isUseOnlyCustomCookieName();
        if (hdrVals == null && !DEFAULT_SSO_COOKIE_NAME.equalsIgnoreCase(cookieName) && !useOnlyCustomCookieName) {
            hdrVals = CookieHelper.getCookieValues(cookies, DEFAULT_SSO_COOKIE_NAME);
        }
        if (hdrVals != null) {
            for (int n = 0; n < hdrVals.length; ++n) {
                boolean checkLoggedOutToken;
                String hdrVal = hdrVals[n];
                if (hdrVal == null || hdrVal.length() <= 0) continue;
                String ltpa64 = hdrVal;
                boolean bl2 = checkLoggedOutToken = this.webAppSecurityConfig != null && this.webAppSecurityConfig.isTrackLoggedOutSSOCookiesEnabled();
                if (checkLoggedOutToken && this.isTokenLoggedOut(ltpa64)) {
                    this.cleanupLoggedOutToken(req, res);
                    return authResult;
                }
                AuthenticationData authenticationData = this.createAuthenticationData(req, res, ltpa64, LTPA_OID);
                try {
                    Subject authenticatedSubject = this.authenticationService.authenticate("system.WEB_INBOUND", authenticationData, null);
                    authResult = new AuthenticationResult(AuthResult.SUCCESS, authenticatedSubject, this.ssoCookieHelper.getSSOCookiename(), null, "success");
                    return authResult;
                }
                catch (AuthenticationException e) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)"handleSSO Exception: ", (Object[])new Object[]{e});
                }
            }
        }
        return authResult;
    }

    private AuthenticationResult handleJwtSSO(HttpServletRequest req, HttpServletResponse res) {
        String jwtCookieName = JwtSSOTokenHelper.getJwtCookieName();
        if (jwtCookieName == null) {
            return null;
        }
        String encodedjwtssotoken = this.ssoCookieHelper.getJwtSsoTokenFromCookies(req, jwtCookieName);
        if (encodedjwtssotoken == null) {
            encodedjwtssotoken = this.getJwtBearerToken(req);
        }
        if (encodedjwtssotoken == null) {
            return null;
        }
        if (LoggedOutJwtSsoCookieCache.contains(encodedjwtssotoken)) {
            String LoggedOutMsg = "JWT_ALREADY_LOGGED_OUT";
            if (req.getAttribute(LoggedOutMsg) == null) {
                Tr.audit((TraceComponent)tc, (String)LoggedOutMsg, (Object[])new Object[0]);
                req.setAttribute(LoggedOutMsg, (Object)"true");
            }
            this.ssoCookieHelper.removeSSOCookieFromResponse(res);
            return new AuthenticationResult(AuthResult.FAILURE, Tr.formatMessage((TraceComponent)tc, (String)LoggedOutMsg, (Object[])new Object[0]));
        }
        return this.authenticateWithJwt(req, res, encodedjwtssotoken);
    }

    private boolean isTokenLoggedOut(String ltpaToken) {
        boolean loggedOut = false;
        Object entry = LoggedOutTokenCacheImpl.getInstance().getDistributedObjectLoggedOutToken(ltpaToken);
        if (entry != null) {
            loggedOut = true;
        }
        return loggedOut;
    }

    private void cleanupLoggedOutToken(HttpServletRequest req, HttpServletResponse res) {
        AuthenticateApi aa = new AuthenticateApi(this.ssoCookieHelper, this.authenticationService);
        aa.simpleLogout(req, res);
    }

    private AuthenticationData createAuthenticationData(HttpServletRequest req, HttpServletResponse res, String token, String oid) {
        WSAuthenticationData authenticationData = new WSAuthenticationData();
        authenticationData.set("HTTP_SERVLET_REQUEST", (Object)req);
        authenticationData.set("HTTP_SERVLET_RESPONSE", (Object)res);
        if (oid.equals(LTPA_OID)) {
            authenticationData.set("TOKEN64", (Object)token);
        } else {
            authenticationData.set("JWT_TOKEN", (Object)token);
        }
        authenticationData.set("AUTHENTICATION_MECH_OID", (Object)oid);
        return authenticationData;
    }

    public AuthenticationResult authenticate(HttpServletRequest req, HttpServletResponse res, HashMap props) throws Exception {
        return null;
    }

    @FFDCIgnore(value={AuthenticationException.class})
    private AuthenticationResult authenticateWithJwt(HttpServletRequest req, HttpServletResponse res, String jwtToken) {
        AuthenticationResult authResult = null;
        try {
            AuthenticationData authenticationData = this.createAuthenticationData(req, res, jwtToken, JWT_OID);
            Subject new_subject = this.authenticationService.authenticate("system.WEB_INBOUND", authenticationData, null);
            authResult = new AuthenticationResult(AuthResult.SUCCESS, new_subject, "jwtToken", null, "success");
            this.ssoCookieHelper.addJwtSsoCookiesToResponse(new_subject, req, res);
        }
        catch (AuthenticationException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"authenticateWithJwt exception: ", (Object[])new Object[]{e});
            }
            authResult = new AuthenticationResult(AuthResult.FAILURE, e.getMessage());
        }
        return authResult;
    }

    private String getJwtBearerToken(HttpServletRequest req) {
        String token = this.getBearerTokenFromHeader(req);
        return token;
    }

    private String getBearerTokenFromParameter(HttpServletRequest req) {
        String contentType;
        String param = null;
        String reqMethod = req.getMethod();
        if (REQ_METHOD_POST.equalsIgnoreCase(reqMethod) && REQ_CONTENT_TYPE_APP_FORM_URLENCODED.equals(contentType = req.getHeader(REQ_CONTENT_TYPE_NAME))) {
            param = req.getParameter(ACCESS_TOKEN);
        }
        return param;
    }

    private String getBearerTokenFromHeader(HttpServletRequest req) {
        String hdrValue = req.getHeader(Authorization_Header);
        String bearerAuthzMethod = "Bearer ";
        if (hdrValue != null && hdrValue.startsWith(bearerAuthzMethod)) {
            return hdrValue.substring(bearerAuthzMethod.length());
        }
        return null;
    }

    protected boolean isLtpaAuthFilterAccept(HttpServletRequest req) {
        SSOAuthFilter ssoAuthFilter;
        if (this.ssoAuthFilterRef != null && (ssoAuthFilter = (SSOAuthFilter)this.ssoAuthFilterRef.getService()) != null) {
            return ssoAuthFilter.processRequest(req);
        }
        return true;
    }

    protected boolean isJwtAuthFilterAccept(HttpServletRequest req) {
        SSOAuthFilter ssoAuthFilter;
        String pid = JwtSSOTokenHelper.getAuthFilterRef();
        if (pid != null && this.ssoAuthFilterRef != null && (ssoAuthFilter = (SSOAuthFilter)this.ssoAuthFilterRef.getService()) != null) {
            return ssoAuthFilter.processRequest(req, pid);
        }
        return true;
    }
}

