/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.internal;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class StackFinder
extends SecurityManager {
    public static StackFinder getInstance() {
        return StackFinderSingleton.instance;
    }

    public Class<Object> getCaller() {
        Class<?>[] stack;
        Class<?> aClass = null;
        for (Class<?> bClass : stack = this.getClassContext()) {
            String name = bClass.getName();
            if (name.endsWith("ras.Tr") || name.endsWith("ras.TraceNLS") || name.endsWith("internal.StackFinder") || name.endsWith("internal.TraceNLSResolver") || name.endsWith("internal.WsLogger")) continue;
            aClass = bClass;
            break;
        }
        return aClass;
    }

    public Class<Object> getCaller(String name) {
        Class<Object> aClass = this.matchCaller(name);
        if (aClass == null) {
            aClass = this.getCaller();
        }
        return aClass;
    }

    public Class<Object> matchCaller(String className) {
        Class<?>[] stack;
        for (Class<Object> clazz : stack = this.getClassContext()) {
            if (!clazz.getName().equals(className)) continue;
            return clazz;
        }
        return null;
    }

    public boolean callstackContains(String fragment) {
        Class<?>[] stack;
        for (Class<?> bClass : stack = this.getClassContext()) {
            if (!bClass.getName().contains(fragment)) continue;
            return true;
        }
        return false;
    }

    public Bundle getTopBundleFromCallStack() {
        Class<?>[] stack;
        for (Class<?> bClass : stack = this.getClassContext()) {
            Bundle bundle = FrameworkUtil.getBundle(bClass);
            if (bundle == null || bundle.getBundleContext() == null) continue;
            return bundle;
        }
        return null;
    }

    private static class StackFinderSingleton {
        static final StackFinder instance = AccessController.doPrivileged(new PrivilegedAction<StackFinder>(){

            @Override
            public StackFinder run() {
                return new StackFinder();
            }
        });

        private StackFinderSingleton() {
        }
    }
}

