/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.authentication.internal.cache.keyproviders;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.common.internal.encoder.Base64Coder;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.authentication.cache.CacheContext;
import com.ibm.ws.security.authentication.cache.CacheKeyProvider;
import com.ibm.ws.security.authentication.internal.SSOTokenHelper;
import com.ibm.ws.security.authentication.utility.SubjectHelper;
import com.ibm.wsspi.security.token.SingleSignonToken;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Hashtable;
import javax.security.auth.Subject;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class SSOTokenBytesCacheKeyProvider
implements CacheKeyProvider {
    private static final String[] disableLtpaSSOCache;
    static final long serialVersionUID = -2865591428264452427L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public Object provideKey(CacheContext context) {
        return this.getSingleSignonTokenBytes(context.getSubject());
    }

    private String getSingleSignonTokenBytes(final Subject subject) {
        String base64EncodedSSOTokenBytes = null;
        if (this.isDisableLtpaSSOCache(subject)) {
            return null;
        }
        SingleSignonToken ssoToken = AccessController.doPrivileged(new PrivilegedAction<SingleSignonToken>(){
            static final long serialVersionUID = 8970637298813979619L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public SingleSignonToken run() {
                return SSOTokenHelper.getSSOToken(subject);
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.authentication.internal.cache.keyproviders.SSOTokenBytesCacheKeyProvider$1", 1.class, null, null);
            }
        });
        if (ssoToken != null) {
            base64EncodedSSOTokenBytes = Base64Coder.toString((byte[])Base64Coder.base64Encode((byte[])ssoToken.getBytes()));
        }
        return base64EncodedSSOTokenBytes;
    }

    private boolean isDisableLtpaSSOCache(Subject subject) {
        SubjectHelper subjectHelper = new SubjectHelper();
        Hashtable hashtable = subjectHelper.getHashtableFromSubject(subject, disableLtpaSSOCache);
        if (hashtable != null) {
            Boolean dlCookie = (Boolean)hashtable.get("com.ibm.ws.authentication.internal.sso.disable.ltpa.cookie");
            Boolean dlCache = (Boolean)hashtable.get("com.ibm.ws.authentication.internal.sso.disable.ltpa.cache");
            if (dlCookie != null && dlCache != null && dlCookie.booleanValue() && dlCache.booleanValue()) {
                return true;
            }
        }
        return false;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.authentication.internal.cache.keyproviders.SSOTokenBytesCacheKeyProvider", SSOTokenBytesCacheKeyProvider.class, null, null);
        disableLtpaSSOCache = new String[]{"com.ibm.ws.authentication.internal.sso.disable.ltpa.cookie", "com.ibm.ws.authentication.internal.sso.disable.ltpa.cache"};
    }
}

