/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;

public class DiskCacheSizeInfo {
    private static TraceComponent tc = Tr.register(DiskCacheSizeInfo.class, (String)"WebSphere Dynamic Cache", (String)"com.ibm.ws.cache.resources.dynacache");
    private static final boolean IS_UNIT_TEST = false;
    public static final long GB_SIZE = 0x40000000L;
    public static final long MB_SIZE = 0x100000L;
    public static final int TYPE_CACHE_DATA = 1;
    public static final int TYPE_DEPENDENCY_ID_DATA = 2;
    public static final int TYPE_TEMPLATE_DATA = 3;
    private String cacheName;
    protected int diskCacheSizeLimit = 0;
    protected int diskCacheSizeHighLimit = 0;
    protected int diskCacheSizeLowLimit = 0;
    protected int highThreshold = 0;
    protected int lowThreshold = 0;
    protected long diskCacheEntrySizeInBytesLimit = 0L;
    protected int diskCacheSizeInGBLimit = 0;
    private long diskCacheSizeInBytesLimit = 0L;
    private long diskCacheSizeInBytesHighLimit = 0L;
    private long diskCacheSizeInBytesLowLimit = 0L;
    protected int currentDataGB = 0;
    protected int currentDependencyIdGB = 0;
    protected int currentTemplateGB = 0;
    protected boolean allowOverflow = false;

    public DiskCacheSizeInfo(String cacheName) {
        this.cacheName = cacheName;
    }

    public void initialize(int diskCacheSizeLimit, int diskCacheEntrySizeInMBLimit, int diskCacheSizeInGBLimit, int dataGB, int dependencyIdGB, int templateGB, int highThreshold, int lowThreshold) {
        String methodName = "initialize()";
        this.diskCacheSizeLimit = diskCacheSizeLimit;
        this.diskCacheSizeInGBLimit = diskCacheSizeInGBLimit;
        this.diskCacheEntrySizeInBytesLimit = (long)diskCacheEntrySizeInMBLimit * 0x100000L;
        this.highThreshold = highThreshold;
        this.lowThreshold = lowThreshold;
        this.currentDataGB = dataGB;
        this.currentDependencyIdGB = dependencyIdGB;
        this.currentTemplateGB = templateGB;
        if (this.diskCacheSizeLimit > 0) {
            this.diskCacheSizeHighLimit = this.diskCacheSizeLimit * this.highThreshold / 100;
            this.diskCacheSizeLowLimit = this.diskCacheSizeLimit * this.lowThreshold / 100;
            this.traceDebug("initialize()", "cacheName=" + this.cacheName + " diskCacheSizeLimit=" + this.diskCacheSizeLimit + " diskCacheSizeHighLimit=" + this.diskCacheSizeHighLimit + " diskCacheSizeLowLimit=" + this.diskCacheSizeLowLimit);
        }
        if (this.diskCacheSizeInGBLimit > 0) {
            this.diskCacheSizeInBytesLimit = (long)(diskCacheSizeInGBLimit - this.currentDependencyIdGB - this.currentTemplateGB) * 0x40000000L;
            this.diskCacheSizeInBytesHighLimit = this.diskCacheSizeInBytesLimit * (long)this.highThreshold / 100L;
            this.diskCacheSizeInBytesLowLimit = this.diskCacheSizeInBytesLimit * (long)this.lowThreshold / 100L;
            this.traceDebug("initialize()", "cacheName=" + this.cacheName + " diskCacheSizeInBytesLimit=" + this.diskCacheSizeInBytesLimit + " diskCacheSizeInBytesHighLimit=" + this.diskCacheSizeInBytesHighLimit + " diskCacheSizeInBytesLowLimit=" + this.diskCacheSizeInBytesLowLimit + " currentDataGB=" + this.currentDataGB + " currentDependencyIdGB=" + this.currentDependencyIdGB + " currentTemplateGB=" + this.currentTemplateGB);
        }
    }

    public synchronized boolean checkAddVolume(int type, int vol) {
        String methodName = "checkAddVolume()";
        if (this.diskCacheSizeInGBLimit > 0) {
            boolean bCalculateHighAndLow = false;
            int minGB = 0;
            switch (type) {
                case 1: {
                    if (this.currentDataGB >= vol + 1) {
                        return true;
                    }
                    if (this.allowOverflow) {
                        this.traceDebug("checkAddVolume()", "cacheName=" + this.cacheName + " allow overflow for data file vol=" + vol);
                        return true;
                    }
                    minGB = this.currentDataGB + this.currentDependencyIdGB + this.currentTemplateGB + 1;
                    if (this.diskCacheSizeInGBLimit >= minGB) {
                        ++this.currentDataGB;
                        break;
                    }
                    this.traceDebug("checkAddVolume()", "data over limit cacheName=" + this.cacheName + " add type=" + type + " diskCacheSizeInGBLimit=" + this.diskCacheSizeInGBLimit + " currentDataGB=" + this.currentDataGB + " currentDependencyIdGB=" + this.currentDependencyIdGB + " currentTemplateGB=" + this.currentTemplateGB);
                    return false;
                }
                case 2: {
                    if (this.currentDependencyIdGB >= vol + 1) {
                        return true;
                    }
                    if (this.allowOverflow) {
                        this.traceDebug("checkAddVolume()", "cacheName=" + this.cacheName + " allow overflow for dependency file id vol=" + vol);
                        return true;
                    }
                    minGB = this.currentDataGB + this.currentDependencyIdGB + this.currentTemplateGB + 1;
                    if (this.diskCacheSizeInGBLimit >= minGB) {
                        ++this.currentDependencyIdGB;
                        bCalculateHighAndLow = true;
                        break;
                    }
                    this.traceDebug("checkAddVolume()", "depId over limit cacheName=" + this.cacheName + " add type=" + type + " diskCacheSizeInGBLimit=" + this.diskCacheSizeInGBLimit + " currentDataGB=" + this.currentDataGB + " currentDependencyIdGB=" + this.currentDependencyIdGB + " currentTemplateGB=" + this.currentTemplateGB);
                    return false;
                }
                case 3: {
                    if (this.currentTemplateGB >= vol + 1) {
                        return true;
                    }
                    if (this.allowOverflow) {
                        this.traceDebug("checkAddVolume()", "cacheName=" + this.cacheName + " allow overflow for template file vol=" + vol);
                        return true;
                    }
                    minGB = this.currentDataGB + this.currentDependencyIdGB + this.currentTemplateGB + 1;
                    if (this.diskCacheSizeInGBLimit >= minGB) {
                        ++this.currentTemplateGB;
                        bCalculateHighAndLow = true;
                        break;
                    }
                    this.traceDebug("checkAddVolume()", "template over limit cacheName=" + this.cacheName + " add type=" + type + " diskCacheSizeInGBLimit=" + this.diskCacheSizeInGBLimit + " currentDataGB=" + this.currentDataGB + " currentDependencyIdGB=" + this.currentDependencyIdGB + " currentTemplateGB=" + this.currentTemplateGB);
                    return false;
                }
            }
            if (bCalculateHighAndLow) {
                this.diskCacheSizeInBytesLimit = (long)(this.diskCacheSizeInGBLimit - this.currentDependencyIdGB - this.currentTemplateGB) * 0x40000000L;
                this.diskCacheSizeInBytesHighLimit = this.diskCacheSizeInBytesLimit * (long)this.highThreshold / 100L;
                this.diskCacheSizeInBytesLowLimit = this.diskCacheSizeInBytesLimit * (long)this.lowThreshold / 100L;
                this.traceDebug("checkAddVolume()", "new limit: cacheName=" + this.cacheName + " add type=" + type + " diskCacheSizeInBytesLimit=" + this.diskCacheSizeInBytesLimit + " diskCacheSizeInBytesHighLimit=" + this.diskCacheSizeInBytesHighLimit + " diskCacheSizeInBytesLowLimit=" + this.diskCacheSizeInBytesLowLimit);
            }
            this.traceDebug("checkAddVolume()", "cacheName=" + this.cacheName + " add volume=" + vol + " type=" + type + " currentDataGB=" + this.currentDataGB + " currentDependencyIdGB=" + this.currentDependencyIdGB + " currentTemplateGB=" + this.currentTemplateGB);
        }
        return true;
    }

    public synchronized void reset() {
        String methodName = "reset()";
        this.currentDataGB = 1;
        if (this.currentDependencyIdGB > 0) {
            this.currentDependencyIdGB = 1;
        }
        if (this.currentTemplateGB > 0) {
            this.currentTemplateGB = 1;
        }
        if (this.diskCacheSizeInGBLimit > 0) {
            this.diskCacheSizeInBytesLimit = (long)(this.diskCacheSizeInGBLimit - this.currentDependencyIdGB - this.currentTemplateGB) * 0x40000000L;
            this.diskCacheSizeInBytesHighLimit = this.diskCacheSizeInBytesLimit * (long)this.highThreshold / 100L;
            this.diskCacheSizeInBytesLowLimit = this.diskCacheSizeInBytesLimit * (long)this.lowThreshold / 100L;
            this.traceDebug("reset()", "cacheName=" + this.cacheName + " diskCacheSizeInBytesLimit=" + this.diskCacheSizeInBytesLimit + " diskCacheSizeInBytesHighLimit=" + this.diskCacheSizeInBytesHighLimit + " diskCacheSizeInBytesLowLimit=" + this.diskCacheSizeInBytesLowLimit + " currentDataGB=" + this.currentDataGB + " currentDependencyIdGB=" + this.currentDependencyIdGB + " currentTemplateGB=" + this.currentTemplateGB);
        }
    }

    public synchronized long getDiskCacheSizeInBytesHighLimit() {
        return this.diskCacheSizeInBytesHighLimit;
    }

    public synchronized long getDiskCacheSizeInBytesLowLimit() {
        return this.diskCacheSizeInBytesLowLimit;
    }

    public synchronized long getDiskCacheSizeInBytesLimit() {
        return this.diskCacheSizeInBytesLimit;
    }

    public long getDiskCacheSizeHighLimit() {
        return this.diskCacheSizeHighLimit;
    }

    public long getDiskCacheSizeLowLimit() {
        return this.diskCacheSizeLowLimit;
    }

    public long getDiskCacheSizeLimit() {
        return this.diskCacheSizeLimit;
    }

    public long getDiskCacheEntrySizeInBytesLimit() {
        return this.diskCacheEntrySizeInBytesLimit;
    }

    public void displayDiskCacheInfo() {
        String methodName = "displayDiskCacheInfo()";
        if (this.diskCacheSizeLimit > 0) {
            this.traceDebug("displayDiskCacheInfo()", "cacheName=" + this.cacheName + " diskCacheSizeLimit=" + this.diskCacheSizeLimit + " diskCacheSizeHighLimit=" + this.diskCacheSizeHighLimit + " diskCacheSizeLowLimit=" + this.diskCacheSizeLowLimit);
        }
        if (this.diskCacheSizeInGBLimit > 0) {
            this.traceDebug("displayDiskCacheInfo()", "cacheName=" + this.cacheName + " diskCacheSizeInBytesLimit=" + this.diskCacheSizeInBytesLimit + " diskCacheSizeInBytesHighLimit=" + this.diskCacheSizeInBytesHighLimit + " diskCacheSizeInBytesLowLimit=" + this.diskCacheSizeInBytesLowLimit + " currentDataGB=" + this.currentDataGB + " currentDependencyIdGB=" + this.currentDependencyIdGB + " currentTemplateGB=" + this.currentTemplateGB);
        }
    }

    public boolean doYield(int currentDiskCacheSize, long currentDiskCacheSizeInBytes) {
        boolean rc = true;
        if (this.diskCacheSizeLimit > 0 && currentDiskCacheSize > this.diskCacheSizeHighLimit) {
            rc = false;
        }
        if (this.diskCacheSizeInGBLimit > 0 && currentDiskCacheSizeInBytes > this.diskCacheSizeInBytesHighLimit) {
            rc = false;
        }
        return rc;
    }

    private void traceDebug(String methodName, String message) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(methodName + " " + message), (Object[])new Object[0]);
        }
    }
}

