/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.opentracing.filters;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.opentracing.filters.SpanFilter;
import com.ibm.ws.opentracing.filters.SpanFilterType;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.net.URI;
import java.util.regex.Pattern;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public abstract class SpanFilterBase
implements SpanFilter {
    private static final TraceComponent tc = Tr.register(SpanFilterBase.class, (String)"OPENTRACING", (String)"com.ibm.ws.opentracing.resources.Opentracing");
    protected final String pattern;
    protected final SpanFilterType type;
    protected final boolean ignoreCase;
    protected final boolean compareRelative;
    protected final boolean wildcard;
    protected final boolean regex;
    protected final Pattern matcher;
    static final long serialVersionUID = -8907736779751603502L;

    public SpanFilterBase(String pattern, SpanFilterType type, boolean ignoreCase, boolean regex) {
        this.type = type;
        this.ignoreCase = ignoreCase;
        this.regex = regex;
        this.matcher = this.regex ? Pattern.compile(pattern, this.ignoreCase ? 2 : 0) : null;
        String processedPattern = pattern.trim();
        if (ignoreCase) {
            processedPattern = processedPattern.toLowerCase();
        }
        this.wildcard = processedPattern.endsWith("*");
        if (this.wildcard) {
            processedPattern = processedPattern.substring(0, processedPattern.length() - 2);
        }
        this.pattern = processedPattern;
        this.compareRelative = !pattern.startsWith("http://") && !pattern.startsWith("https://");
        this.validatePattern();
    }

    @Override
    @Trivial
    public String getPattern() {
        return this.pattern;
    }

    @Override
    @Trivial
    public SpanFilterType getType() {
        return this.type;
    }

    @Trivial
    public String toString() {
        return super.toString() + " { pattern: \"" + this.pattern + "\", type: \"" + (Object)((Object)this.type) + "\", regex: \"" + this.matcher + "\" }";
    }

    /*
     * WARNING - void declaration
     */
    protected void validatePattern() {
        if (this.pattern.length() == 0) {
            throw new IllegalArgumentException(Tr.formatMessage((TraceComponent)tc, (String)"OPENTRACING_FILTER_PATTERN_BLANK", (Object[])new Object[0]));
        }
        if (!this.regex) {
            try {
                URI.create(this.pattern);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                void e;
                FFDCFilter.processException((Throwable)illegalArgumentException, (String)"com.ibm.ws.opentracing.filters.SpanFilterBase", (String)"111", (Object)this, (Object[])new Object[0]);
                throw new IllegalArgumentException(Tr.formatMessage((TraceComponent)tc, (String)"OPENTRACING_FILTER_PATTERN_INVALID", (Object[])new Object[]{this.pattern}), (Throwable)e);
            }
        }
    }

    protected boolean match(URI uri) {
        String uriStr = this.prepareUri(uri);
        return this.match(uriStr);
    }

    protected boolean match(String path) {
        String methodName = "match";
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"match", (Object[])new Object[]{this, path, this.ignoreCase, this.wildcard});
        }
        if (this.matcher == null) {
            if (this.ignoreCase) {
                if (this.pattern.equalsIgnoreCase(path)) {
                    return true;
                }
                if (this.wildcard && path.toLowerCase().startsWith(this.pattern)) {
                    return true;
                }
            } else {
                if (this.pattern.equals(path)) {
                    return true;
                }
                if (this.wildcard && path.startsWith(this.pattern)) {
                    return true;
                }
            }
        } else {
            return this.matcher.matcher(path).matches();
        }
        return false;
    }

    protected final String prepareUri(URI uri) {
        if (this.compareRelative) {
            String path = uri.getRawPath();
            String query = uri.getRawQuery();
            String fragment = uri.getRawFragment();
            if (query != null && fragment != null) {
                return path + "?" + query + "#" + fragment;
            }
            if (query != null) {
                return path + "?" + query;
            }
            if (fragment != null) {
                return path + "#" + fragment;
            }
            return path;
        }
        return uri.toString();
    }

    protected final boolean contextApplies(SpanFilterType contextType) {
        return (this.type.getValue() & contextType.getValue()) != 0;
    }

    @Override
    public boolean process(boolean previousState, URI uri, String path, SpanFilterType contextType) {
        if (this.contextApplies(contextType) && this.match(uri)) {
            return this.matchAction(previousState, uri, path, contextType);
        }
        return previousState;
    }

    protected abstract boolean matchAction(boolean var1, URI var2, String var3, SpanFilterType var4);
}

